import argparse

parser = argparse.ArgumentParser()

# training ralated
parser.add_argument('--nodes', type=int, default=8, help='Number of nodes in distributed training')
parser.add_argument('--n_gpu', type=int, default=8, help='Number of gpus in distributed training')
parser.add_argument('--topo', type=str, default='exp', choices=['1', 'sep', '2', 'full', '3', 'exp', '4', 'ring', '5', 'dense', '6', 'directed-ring']
                    , help='Topology used in distributed training')

parser.add_argument('--which_sum', choices=['state_sum', 'total_sum'], help='Which variable is used to update the sum of norm')
parser.add_argument('--opt_comm', action='store_true', help='If communicate optimizer parameters')

parser.add_argument('--num_epoch', type=int, default=200, help='number of epochs')
parser.add_argument('--batchsize', type=int, default=128, help='batch size')
parser.add_argument('--dataset', type=str, default='mnist', choices=['mnist', 'cifar10'], help='choose dataset')
parser.add_argument('--gamma', type=float, default=1.3, help='gamma in the loss')
parser.add_argument('--epsilon', type=float, default=0.1, help='attack level')
parser.add_argument('--s_rate', type=float, default=1, help='shuffle rate')
parser.add_argument('--label_num', type=int, default=1, help='label classes in every node')
parser.add_argument('--model', type=str, default='CNN', choices=['MLP', 'CNN', 'LeNet'], help='model used')

# Optimizer
parser.add_argument('--optim', type=str, default='adam', help='optimization method')
parser.add_argument('--lr_x', type=float, default=0.0002, help='learning rate for g')
parser.add_argument('--lr_y', type=float, default=0.0002, help='learning rate for c')

parser.add_argument('--alpha', type=float, default=0.6, help='parameter for TiAda')
parser.add_argument('--beta', type=float, default=0.4, help='parameter for TiAda')
parser.add_argument('--n_inner', type=int, default=15, help='number of inner loop steps')

# directory related
parser.add_argument('--model_name', type=str, default=None, help='sub-directory name')

# others
parser.add_argument('--seed', type=int, default=8, help='random seed for reproducibility')
parser.add_argument('--device', type=int, default=0, help='used device')

parser.add_argument('--dist-url', default='tcp://127.0.0.1:55004', type=str,
                help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='gloo', type=str,
                help='distributed backend')

# parse
args = parser.parse_args()
