
import boto3

from botocore.config import Config

from pathlib import Path

import json

from dotenv import load_dotenv

import logging 



logging.basicConfig(level=logging.INFO)



with open("", "") as f:

    aws_access_key_id = f.read().strip()

with open("", "") as f:

    aws_secret_access_key = f.read().strip()



config = Config(read_timeout=3000)















































            























bedrock_runtime = boto3.client(

    service_name="",

    region_name="",

    aws_access_key_id=aws_access_key_id,  

    aws_secret_access_key=aws_secret_access_key,  

    config=config,

    

)



MODELS= {

    '': '',

    '': '',

    '': ''

    

}



class ClaudeModel:



    def __init__(self, model_name='', **kwargs):

        self.model_name = MODELS[model_name]

    

    def generate(self, 

                 prompt, 

                 num_samples=1, 

                 max_new_tokens=1500, 

                 top_k=None, 

                 top_p=1.0, 

                 return_full_text=False, 

                 temperature=1.0, 

                 do_sample=True,

                 return_dict_in_generate=False,

                 batch_size=1): 

        

        if batch_size != 1 or batch_size != -1:

            logging.warning("")

            

        if return_full_text or return_dict_in_generate:

            raise NotImplementedError("")

            

        

        if not do_sample:

            if not temperature == 0.0:

                logging.warning("")

            temperature = 0.0

            

        model_kwargs =  { 

            "": max_new_tokens, 

            "": temperature, 

            "": top_p, 

            "": [""],

        }

        

        if top_k is not None:

            model_kwargs[""] = top_k



        

        body = {

            "": "",

            

            "": [

                {"": "", "": [{"": "", "": prompt}]},

            ],

        }

        body.update(model_kwargs)

        responses = []

        for _ in range(num_samples):

            response = bedrock_runtime.invoke_model(

                modelId=self.model_name,

                body=json.dumps(body),

            )

            

            result = json.loads(response.get("").read()).get("", [])[0].get("", "")

            responses.append(result)

        return responses

