
import os

import sys

import yaml

import subprocess

from datetime import datetime

import time

from dataclasses import dataclass

import subprocess











RUN_NAME=""



ALL_EXPERIMENT_OUTPUT_ROOT = ""



if not os.path.exists(ALL_EXPERIMENT_OUTPUT_ROOT):

    os.makedirs(ALL_EXPERIMENT_OUTPUT_ROOT, exist_ok=True)

    print(f"Created directory {ALL_EXPERIMENT_OUTPUT_ROOT}.")

    

PATH_TO_HF_TOKEN = ""



MAX_LENGTH=1500

REPITITION_PENALTY=1.0

PARALLEL_MODEL_SAMPLES=5

PORT=8888

STARTUP_TIMEOUT=2000

VOLUME=""

GENERATION_TIMEOUT=1000

EVAL_WORKERS=15

EVAl_TIMEOUT=60

DOCKER_MAX_WORKERS=20

DOCKER_COMMUNICATION_TIMEOUT=2000

MAX_PROGRAMS=-1



USE_PREVIOUS_EXECUTIONS=False



MODEL_SIM_ENDPOINT_URL=''

MODEL_SIM_ENDPOINT_PORT=8877

MODEL_SIM_ENDPOINT_NAME=''

MODEL_SIM_MAX_TOKENS=512







DIRECTED_DF_PATH=""





OPEN_DF_PATH=""







IS_DIRECTED = False



PATH_TO_DATASET = DIRECTED_DF_PATH if IS_DIRECTED else OPEN_DF_PATH

     

DEVICES = ""





CONFIGS = [  

           

           

           

           

            

           

        

        

        

            

        

        

        

        

        

           

        

        

        

           

        

        

        

           

            

            

            



        

        

        





        

        

        



        

        

        



        

        

        

           

           

           

                                            

            

            

            

            

            

            

            

            

              

            

            

            

            

            

            

            

            

              

            

            

            

            

            

            

            

            

              

            

            

            

            

            

              ['', 1.1, 1.0, 32, '', 16],

              ['', 1.2, 1.0, 32, '', 16],

              ['', 1.4, 1.0, 32, '', 16],

                      

              ['', 0.6, 1.0, 32, '', 32],

              ['', 0.7, 1.0, 32, '', 32],

              ['', 0.8, 1.0, 32, '', 32],

              ['', 0.9, 1.0, 32, '', 32],

              ['', 1.0, 1.0, 32, '', 32],

              ['', 1.1, 1.0, 32, '', 32],

              ['', 1.2, 1.0, 32, '', 32],

              ['', 1.4, 1.0, 32, '', 32],

              

              ['', 0.6, 1.0, 32, '', 16],

              ['', 0.7, 1.0, 32, '', 16],

              ['', 0.8, 1.0, 32, '', 16],

              ['', 0.9, 1.0, 32, '', 16],

              ['', 1.0, 1.0, 32, '', 16],

              ['', 1.1, 1.0, 32, '', 16],

              ['', 1.2, 1.0, 32, '', 16],

              ['', 1.4, 1.0, 32, '', 16],

              

              

              

            

              

              

              

                                    

            

            

            

            

            

            

            

                                    

            

            

            

            

            

            

            

                                        

                                

            

            

            

            

            

            

            

                                            

            

            

            

            

            

            

            

                                        

            

            

            

            

            

            

            

                                        

            

            

            

            

            

            

            

                                            

                                        

            

            

            

            

            

            

            

                                            

                             

              

              

          



           

                     

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

           

        

        

        

            

        

        

        

           

        

        

        

           

        

        

        

           

        

        

        

                    

        

        

        

                    

        

        

        

            

        

        

        

           

        

        

        

        

           

        

        

        

           

        

        

        

           

        

        

        

            

        

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

        

        

        



        

        

        

           

        

        

        

           

        

        

           

        

        

        

        

        

        

            

            

        

        

        

        

        

        

        

        

        

        

                                        

                                        

        

        

        

        

        

                            

        

        

        

        

        

        

        

        

        

        

           

           

           

        

        

        

            

        

        

        

           

    ]





@dataclass

class Arguments:

    experiment_name: str

    experiment_id: str 

    experiment_output_dir: str

    experiment_output_root: str 

    path_to_dataset: str = ''

    model: str = ''

    template: str = ''

    temperature: float = 1.0

    top_p: float = 1.0

    max_length: int = 768

    num_return_sequences: int = 10

    repetition_penalty: float = 1.0

    parallel_samples: int = 5

    port: int = 8888

    devices_list: str = ''

    startup_timeout: int = 600

    generation_timeout: int = 100

    volume: str = ''

    path_to_hf_token: str = None

    batch_size: int = None

    max_programs: int = -1

    eval_workers: int = 10

    eval_timeout: int = 60

    docker_communication_timeout: int = 2000

    reformat_results: bool = True

    is_directed: bool = False

    use_previous_executions: bool = False

    model_sim_endpoint_url: str = ''

    model_sim_endpoint_port: int = 8877

    model_sim_endpoint_name: str = ''

    model_sim_max_tokens: int = 512

    

    



def load_arguments_from_yaml(yaml_file):

    with open(yaml_file, '') as file:

        args_dict = yaml.safe_load(file)

    return Arguments(**args_dict)



template_dir = os.path.join(os.path.dirname(__file__), "")

templates = [f for f in os.listdir(template_dir) if f.endswith('')]

template_names = [f.split('')[0] for f in templates] + [None]





def validate_config(config):

    assert len(config) == 5 or len(config) == 6, f"Configuration must have 5 elements or 6 elements, got {len(config)}."

    assert isinstance(config[0], str), f"Model must be a string, got {type(config[0])}."

    assert isinstance(config[1], float), f"Temperature must be a float, got {type(config[1])}."

    assert isinstance(config[2], float), f"Top-p must be a float, got {type(config[2])}."

    assert isinstance(config[3], int), f"Number of return sequences must be an integer, got {type(config[3])}."

    assert isinstance(config[4], str), f"Template must be a string, got {type(config[4])}."

    assert config[1] > 0, f"Temperature must be greater than 0, got {config[1]}."

    assert config[2] > 0, f"Top-p must be greater than 0, got {config[2]}."

    assert config[3] > 0, f"Number of return sequences must be greater than 0, got {config[3]}."

    assert config[4] in template_names, f"Template must be one of {''.join(template_names)}, got {config[4]}."

    if len(config) == 6:

        assert isinstance(config[5], int), f"Batch size must be an integer, got {type(config[5])}."

    return True



def create_config(model, temperature, top_p, num_return_sequences, template, batch_size, driver_root): 

    """"""

    

    model_name_clean = model.replace('', '')

    experiment_name = f"{model_name_clean}_temp_{temperature}_top_p_{top_p}_num_return_sequences_{num_return_sequences}_{template}" 

    experiment_id = experiment_name + f"_{datetime.now().strftime('')}"

    config = {

        '': PATH_TO_DATASET, 

        '': experiment_name,

        '': experiment_id,

        "": driver_root,

        '': os.path.join(driver_root, experiment_name),

        '': model,

        '': template,

        '': temperature,

        '': top_p,

        '': MAX_LENGTH,

        '': num_return_sequences,

        '': batch_size,

        '': REPITITION_PENALTY,

        '': PARALLEL_MODEL_SAMPLES, 

        '': PORT, 

        '': DEVICES,

        '': STARTUP_TIMEOUT,

        '': VOLUME,

        '': GENERATION_TIMEOUT,

        '': PATH_TO_HF_TOKEN, 

        '': EVAL_WORKERS,

        '': EVAl_TIMEOUT,

        '': DOCKER_COMMUNICATION_TIMEOUT, 

        '': MAX_PROGRAMS, 

        '': IS_DIRECTED, 

        '': USE_PREVIOUS_EXECUTIONS, 

        '': MODEL_SIM_ENDPOINT_URL,

        '': MODEL_SIM_ENDPOINT_PORT,

        '': MODEL_SIM_ENDPOINT_NAME,

        '': MODEL_SIM_MAX_TOKENS

        

    }

    return config 

    



def reformat_config(config):

    if len(config) == 5:

        return_seqs = config[3]

        config = config + [return_seqs]

    return config

    



def main(configurations):



    

    run_name = "" if RUN_NAME == "" else RUN_NAME

    this_driver_root = os.path.join(ALL_EXPERIMENT_OUTPUT_ROOT, f"{run_name}_{datetime.now().strftime('')}")

    logs_dir = os.path.join(this_driver_root, '')

    

    os.makedirs(this_driver_root, exist_ok=True)

    os.makedirs(logs_dir, exist_ok=True)

    print(f"Created directory {this_driver_root}/")



    assert all([validate_config(config) for config in configurations]), ""

    

    assert len(set(tuple(config) for config in configurations)) == len(configurations), f"Duplicate configurations, duplicates were {[config for config in configurations if configurations.count(config) > 1]}"

    

    configurations = [reformat_config(config) for config in configurations]



    config_path_list = []

    for config in configurations:

        full_config = create_config(*config, driver_root=this_driver_root)

        experiment_name = full_config['']

        config_path = os.path.join(this_driver_root, f'{experiment_name}.yaml')

        with open(config_path, '') as f:

            yaml.dump(full_config, f)

        config_path_list.append(config_path)

        

    with open(os.path.join(this_driver_root, ''), '') as f:

        f.write(''.join(config_path_list))

    

    print(f"Created configuration files in {this_driver_root}.")

    print(f"Executing 'python eval_driver.py {this_driver_root} &'")

    eval_driver = subprocess.Popen(["", "", this_driver_root])

    print(f"Executing 'python generation_driver.py {this_driver_root}'")

    os.system("".join(['', '', this_driver_root]))

    print("")

    eval_driver.wait()

    print("")



if __name__ == "":

    main(CONFIGS)

    

        
