
import os

import sys

sys.path.insert(0,

                os.path.abspath(os.path.join(os.path.dirname(__file__),

                                             '')))

import argparse

import pandas as pd

import json

import numpy as np

from models import gpt, opensource, hf_inference

from utils import textprocessing

from utils.clustering import clustering

from utils.clustering.clustering import tqdm_joblib

import joblib

from joblib import Parallel, delayed

from utils.clustering import lexical_diversity

from utils.clustering.ast_processing import AllSubtreeAnalysis, AstSubTree, parallel_subtree_analysis

from dataclasses import dataclass

import yaml

from tqdm import tqdm

from functools import partial

from datetime import datetime

import traceback

import copy 

import shutil   



import signal

import traceback



from async_driver import Arguments, load_arguments_from_yaml, create_config, reformat_config, validate_config

from eval_driver import results_stats_keys

import logging 

import glob 

import subprocess



logging.basicConfig(level=logging.INFO)





RUN_NAME=""



MAX_PROGRAMS=-1





PATH_TO_HUMAN_RESULTS = ""





ALL_EXPERIMENT_OUTPUT_ROOT = ""



if not os.path.exists(ALL_EXPERIMENT_OUTPUT_ROOT):

    os.makedirs(ALL_EXPERIMENT_OUTPUT_ROOT, exist_ok=True)

    print(f"Created directory {ALL_EXPERIMENT_OUTPUT_ROOT}.")



MOCK_CONFIG = ['', 1.0, 1.0, 100, '', 25]





def main(config): 



    

    run_name = "" if RUN_NAME == "" else RUN_NAME

    this_driver_root = os.path.join(ALL_EXPERIMENT_OUTPUT_ROOT, f"{run_name}_{datetime.now().strftime('')}")

    logs_dir = os.path.join(this_driver_root, '')

    

    os.makedirs(this_driver_root, exist_ok=True)

    os.makedirs(logs_dir, exist_ok=True)

    print(f"Created directory {this_driver_root}/")

    

    assert validate_config(config), ""





    full_config = create_config(*config, driver_root=this_driver_root)

    full_config[""] = True

    full_config[""] = 30

    full_config[""] = MAX_PROGRAMS

    

    experiment_name = full_config['']

    config_path = os.path.join(this_driver_root, f'{experiment_name}.yaml')

    with open(config_path, '') as f:

        yaml.dump(full_config, f)

    

    with open(os.path.join(this_driver_root, ''), '') as f:

        f.write(config_path)

        

    

    experiment_output_dir = full_config[""]

    os.makedirs(experiment_output_dir, exist_ok=True)

    

    shutil.copy(PATH_TO_HUMAN_RESULTS, os.path.join(experiment_output_dir, ''))

    

    logging.info(f"Running eval_driver for {this_driver_root}")

    logging.info(f"Running 'python eval_driver.py {this_driver_root}'")

    p = subprocess.run(["", "", this_driver_root])

    if p.returncode != 0:

        logging.error(f"Error in {this_driver_root}, return code {p.returncode}")    

    else:

        logging.info(f"Experiment {this_driver_root} completed with return code 0")

    

    

if __name__ == "":

    main(MOCK_CONFIG)

        
