
import os

import sys

import yaml

import subprocess

from datetime import datetime





EXPERIMENT_OUTPUT_ROOT = ""

if not os.path.exists(EXPERIMENT_OUTPUT_ROOT):

    os.makedirs(EXPERIMENT_OUTPUT_ROOT, exist_ok=True)

    print(f"Created directory {EXPERIMENT_OUTPUT_ROOT}.")

    

PATH_TO_HF_TOKEN=""





CONFIGS = [  

           

           ['', 1.0, 1.0, 100, '', 25], 

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],

           

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],

           

           ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            ['', 1.0, 1.0, 100, '', 25],

            

            ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],



           

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],   

           ['', 1.0, 1.0, 100, '', 25],

           

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],

           ['', 1.0, 1.0, 100, '', 25],

            

             

        

            

        

        

        

        

        

        

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            

            ['', 1.0, 1.0, 100, '', 4],

            ['', 1.0, 1.0, 100, '', 4], 

            ['', 1.0, 1.0, 100, '', 4],

            

            ['', 1.0, 1.0, 100, '', 4], 

            ['', 1.0, 1.0, 100, '', 4], 

            ['', 1.0, 1.0, 100, '', 4]

            

            

            

            

            

    

    ]



def validate_config(config):

    assert len(config) == 5 or len(config) == 6, f"Configuration must have 5 elements or 6 elements, got {len(config)}."

    assert isinstance(config[0], str), f"Model must be a string, got {type(config[0])}."

    assert isinstance(config[1], float), f"Temperature must be a float, got {type(config[1])}."

    assert isinstance(config[2], float), f"Top-p must be a float, got {type(config[2])}."

    assert isinstance(config[3], int), f"Number of return sequences must be an integer, got {type(config[3])}."

    assert isinstance(config[4], str), f"Template must be a string, got {type(config[4])}."

    assert config[1] > 0, f"Temperature must be greater than 0, got {config[1]}."

    assert config[2] > 0, f"Top-p must be greater than 0, got {config[2]}."

    assert config[3] > 0, f"Number of return sequences must be greater than 0, got {config[3]}."

    assert config[4] in ['', '', ''], f"Template must be one of 'open_ended_default', 'open_ended_two_shot', 'open_ended_two_shot_cot', got {config[4]}."

    if len(config) == 6:

        assert isinstance(config[5], int), f"Batch size must be an integer, got {type(config[5])}."

    return True



def create_yaml_config(model, temperature, top_p, num_return_sequences, template, batch_size, config_dir):

    """"""

    config = {

        '': '',

        "": EXPERIMENT_OUTPUT_ROOT,

        '': model,

        '': template,

        '': temperature,

        '': top_p,

        '': 1500,

        '': num_return_sequences,

        '': batch_size,

        '': 1.0, 

        '': 5, 

        '': 9999, 

        '': '',

        '': 2000,

        '': '',

        '': 1000,

        '': PATH_TO_HF_TOKEN

    }

    

    model_name_clean = model.replace('', '')

    file_path = os.path.join(config_dir, f'config_{model_name_clean}_{temperature}_{top_p}_{num_return_sequences}_{template}.yaml')

    with open(file_path, '') as file:

        yaml.dump(config, file)

    return file_path



def run_experiment(config_path, log_file_path):

    """"""

    command = ['', '', config_path]

    print(f"Running command: {''.join(command)}")

    

    command = command + ["", log_file_path]

    os.system("".join(command))

            

    

    

    with open(config_path, '') as f:

        config = yaml.safe_load(f)

    model = config[''].replace('', '')

    temperature = config['']

    top_p = config['']

    num_return_sequences = config['']

    

    

    dirs = [d for d in os.listdir(EXPERIMENT_OUTPUT_ROOT) if os.path.isdir(os.path.join(EXPERIMENT_OUTPUT_ROOT, d))]

    if len(dirs) == 0:

        print("")

        

        return None

    time_sorted_dirs = sorted(dirs, key=lambda x: datetime.strptime(x[-19:], ''), reverse=True)

    latest_dir = time_sorted_dirs[0]

    results_file = os.path.join(EXPERIMENT_OUTPUT_ROOT, latest_dir, '')

    

    try: 

        with open(results_file, '') as f:

            lines = f.readlines()

        results = {}

        for line in lines:

            k, v = line.strip().split('')

            results[k] = v

        results.update(config)

            

        

        results[""] = model

        print(f"Results for experiment {model}_temp_{temperature}_top_p_{top_p}_num_return_sequences_{num_return_sequences}:")

        print(results)

        return results

    except Exception as e:

        print(f"Error reading in results file: {e}")

        return None

    

def reformat_config(config):

    if len(config) == 5:

        return_seqs = config[3]

        config = config + [return_seqs]

    return config

    



def main(configurations):

    config_dir = ''

    if not os.path.exists(config_dir):

        raise FileNotFoundError(f"Configuration directory {config_dir} not found.")

    



    logs_dir = ''

    os.makedirs(logs_dir, exist_ok=True)

    

    driver_stats_file = os.path.join(EXPERIMENT_OUTPUT_ROOT, f"{datetime.now().strftime('')}_driver_stats.tsv")

    driver_pretty_stats_file = os.path.join(EXPERIMENT_OUTPUT_ROOT, f"{datetime.now().strftime('')}_driver_stats_pretty.txt")

    

    

    

    

    

    

    keys = ['', '', '', '', '']  

    addtl_keys = ['', '', '', '', '', '', '', '', '']

    addtl_keys = addtl_keys + [f"{key}_{height}" for key in ['', '', ''] for height in [3,4,5,6]]

    addtl_keys = [f"{recordtype}_{key}" for recordtype in ['', '', ''] for key in addtl_keys]

    keys = keys + addtl_keys

    

    string_keys = ['', '']

    param_keys = ['', '', '']

    result_keys = [k for k in keys if k not in string_keys + param_keys and "" not in k]

    

    

    with open(driver_stats_file, '') as f:

        f.write(''.join(keys) + '')

    

    

    pretty_column_widths = [46, 15] + [max(len(k) + 2, 6) for k in keys[2:]]

    with open(driver_pretty_stats_file, '') as f:

    

        f.write(''.join([f"{k.ljust(pretty_column_widths[i])}" for i, k in enumerate(keys)]) + '')

        

    assert all([validate_config(config) for config in configurations]), ""

    

    configurations = [reformat_config(config) for config in configurations]



    for config in configurations:

        yaml_path = create_yaml_config(*config, config_dir)

        print(f"Running experiment with configuration {config}")

        

        results = run_experiment(yaml_path, os.path.join(logs_dir, f'log_{config[0].replace("", "")}_{config[1]}_{config[2]}_{config[3]}_{config[4]}_{datetime.now().strftime("")}.txt'))

        if results is not None:

            

            formatted_results = [] 

            for k in keys:

                if k in result_keys:

                    formatted_results.append(round(float(results[k]) * 100, 2))

                elif "" in k:

                    formatted_results.append(round(float(results[k]), 2))

                elif k == "": 

                    formatted_results.append(results[k].replace("", ""))

                else:

                    formatted_results.append(results[k])

                    

        else: 

            

            

            formatted_results = [str(config[0]), str(config[4]), str(config[1]), str(config[2]), str(config[3])] + ['']*(len(keys) - 5)

            

        with open(driver_stats_file, '') as f:

                f.write(''.join([str(k) for k in formatted_results]) + '')

            

        with open(driver_pretty_stats_file, '') as f:

            f.write(''.join([f"{str(k).ljust(pretty_column_widths[i])}" for i, k in enumerate(formatted_results)]) + '')

                

        print(f"Experiment {config} completed.")

        

    print("")



if __name__ == '':

    

    main(CONFIGS)

