


import os

import sys

import yaml

import subprocess

from datetime import datetime

import time

from dataclasses import dataclass

import subprocess

import shutil 

import logging 

import glob 

import re

from tqdm import tqdm



logging.basicConfig(level=logging.INFO)









ALL_EXPERIMENT_OUTPUT_ROOT = ""















RUN_NAME = ""





DIRECTORY_PATHS=[

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    

    "", 

    "", 

    ""

    

    

]







USE_PREVIOUS_EXECUTIONS = True

REFORMAT_RESULTS = True



EXTRA_VERBOSE = False



FIX_OLD_FORMAT = False



EVAL_WORKERS = 5







MODEL_SIM_ENDPOINT_URL=''



MODEL_SIM_ENDPOINT_PORT=8877





def capture_i_and_coh_j(text):

    

    pattern = rr

    

    

    matches = re.findall(pattern, text)

    

    

    if matches and len(matches) == 1 and len(matches[0]) == 2:

        i, coh_j = matches[0]

        return int(i), coh_j

    else:

        logging.critical(f"Error in parsing the output_record: {text}")

        return 99, ""



config_replacement_dict = {

    "": "", 

    "": "", 

    "": ""

}



def main(DIRECTORY_PATHS): 

    

    

    experiment_name = f"{RUN_NAME}_{datetime.now().strftime('')}"

    experiment_output_root = os.path.join(ALL_EXPERIMENT_OUTPUT_ROOT, experiment_name)

    

    

    

    

    

    all_dir_yaml_paths = [line.strip() for directory_path in DIRECTORY_PATHS for line in open(os.path.join(directory_path, ''), '').readlines()]

    all_dir_yaml_paths = [d for d in  all_dir_yaml_paths if "" not in d]

    pbar = tqdm(total=len(all_dir_yaml_paths))

    

    yaml_paths = []

    for directory_path in DIRECTORY_PATHS:

        

        

        

        

        

        

        

        

        

        

        

        

        

        with open(os.path.join(directory_path, ''), '') as f:

            this_dir_yaml_paths = [line.strip() for line in f.readlines()]

            

        for yaml_path in this_dir_yaml_paths: 

            

            

            

            

            for old_path, new_path in config_replacement_dict.items(): 

                yaml_path = yaml_path.replace(old_path, new_path)

                

            with open(yaml_path, '') as f: 

                yaml_dict = yaml.load(f, Loader=yaml.FullLoader)

                

            

            

            this_experiment_output_dir = yaml_dict[""]

            this_experiment_output_root = yaml_dict[""]

            for old_path, new_path in config_replacement_dict.items(): 

                this_experiment_output_dir = this_experiment_output_dir.replace(old_path, new_path)

                this_experiment_output_root = this_experiment_output_root.replace(old_path, new_path)

            

            

            

            

            this_experiment_id = os.path.basename(this_experiment_output_dir)

            assert this_experiment_output_root == directory_path, f"experiment_output_root is not the same as the directory path, something weird is going on: {this_experiment_output_root} != {directory_path}"

            if not this_experiment_output_dir == os.path.join(directory_path, this_experiment_id): 

                import pdb; pdb.set_trace()

                

                for i, (c1, c2) in enumerate(zip(this_experiment_output_dir, os.path.join(directory_path, this_experiment_id))): 

                    if c1 != c2: 

                        print(f"Index {i}: {c1} != {c2}")

                pdb.set_trace()

            assert this_experiment_output_dir.strip() == os.path.join(directory_path, this_experiment_id).strip(), f"experiment_output_dir is not the same as the directory path, something weird is going on: {this_experiment_output_dir} != {os.path.join(directory_path, this_experiment_id)}"

            

            

            if not os.path.exists(os.path.join(this_experiment_output_dir, '')): 

                logging.info(f"Skipping {yaml_path} because results.jsonl does not exist")

                pbar.update(1)

                continue

            

            

            if os.path.exists(os.path.join(experiment_output_root, this_experiment_id)): 

                logging.critical(f"Experiment {this_experiment_id} already exists in {experiment_output_root}")

                pbar.update(1)

                continue

                

            

            new_experiment_output_dir = os.path.join(experiment_output_root, this_experiment_id)

            shutil.copytree(this_experiment_output_dir, new_experiment_output_dir)

            

            yaml_dict[""] = new_experiment_output_dir

            yaml_dict[""] = experiment_output_root

            

            

            yaml_dict[""] = USE_PREVIOUS_EXECUTIONS

            yaml_dict[""] = REFORMAT_RESULTS

            yaml_dict[""] = EVAL_WORKERS

            yaml_dict[""] = MODEL_SIM_ENDPOINT_URL

            yaml_dict[""] = MODEL_SIM_ENDPOINT_PORT

            

            

            

            

            

            

            

            

            old_paths = [os.path.join(new_experiment_output_dir, basename) for basename in ['', '', '', '']]

            for old_path in old_paths:

                if os.path.exists(old_path):

                    if EXTRA_VERBOSE:

                        logging.info(f"Removing {old_path}")

                    os.remove(old_path)

                else: 

                    if EXTRA_VERBOSE:

                        logging.warning(f"Did not find {old_path}")

            

            

                        

            

            new_yaml_path = os.path.join(new_experiment_output_dir, '')

            new_root_yaml_path = os.path.join(experiment_output_root, f"{this_experiment_id}.yaml")

            

            with open(new_yaml_path, '') as f:

                yaml.dump(yaml_dict, f)

        

            with open(new_root_yaml_path, '') as f:

                yaml.dump(yaml_dict, f)

            

            yaml_paths.append(new_yaml_path)



            

            

            

            

            new_experiment_problem_id_dirs = glob.glob(os.path.join(new_experiment_output_dir, ""))

            for new_experiment_problem_id_dir in new_experiment_problem_id_dirs: 

                if os.path.exists(os.path.join(new_experiment_problem_id_dir, '')): 

                    if EXTRA_VERBOSE:

                        logging.info(f"Removing {os.path.join(new_experiment_problem_id_dir, '')}")

                    os.remove(os.path.join(new_experiment_problem_id_dir, ''))

                

                if FIX_OLD_FORMAT: 

                    new_experiments_records = glob.glob(os.path.join(new_experiment_problem_id_dir, ""))

                    

                    for new_experiment_record in new_experiments_records:

                        basename = os.path.splitext(os.path.basename(new_experiment_record))[0]

                        

                        gen_index, suffix = capture_i_and_coh_j(basename)

                        

                        new_experiment_dir = os.path.join(new_experiment_problem_id_dir, f"generation_{gen_index}_{suffix}")

                        os.makedirs(new_experiment_dir, exist_ok=True)

                        

                        shutil.copy(new_experiment_record, os.path.join(new_experiment_dir, ""))

                        

            

            pbar.update(1)

            

    with open(os.path.join(experiment_output_root, ''), '') as f:

        f.write(''.join(yaml_paths))

    

    

    

    

    

        

        

        

        

        

    logging.info("")

    for yaml_path in yaml_paths: 

        with open(yaml_path, '') as f: 

            yaml_dict = yaml.load(f, Loader=yaml.FullLoader)

        

        this_experiment_output_dir = yaml_dict[""]

        this_experiment_output_root = yaml_dict[""]

        

        assert os.path.exists(yaml_path), f"yaml_path {yaml_path} does not exist"

        assert yaml_path.startswith(experiment_output_root), f"yaml_path {yaml_path} does not start with experiment_output_root {experiment_output_root}"

        assert os.path.exists(this_experiment_output_dir), f"experiment_output_dir {this_experiment_output_dir} does not exist"

        assert os.path.exists(this_experiment_output_root), f"experiment_output_root {this_experiment_output_root} does not exist"

        assert os.path.exists(os.path.join(this_experiment_output_dir, '')), f"results.jsonl does not exist in {this_experiment_output_dir}"

        assert this_experiment_output_dir.startswith(this_experiment_output_root), f"experiment_output_dir {this_experiment_output_dir} does not start with experiment_output_root {this_experiment_output_root}"

        assert this_experiment_output_root == experiment_output_root, f"experiment_output_root {this_experiment_output_root} does not match experiment_output_root {experiment_output_root}"

        

    logging.info("")

        

    pbar.close()

    

    p = subprocess.run(["", '', experiment_output_root, ''], capture_output=True)

    logging.info(f"Experiment output root size: {p.stdout.decode().strip()}")

    

    

        

                                   

    

    

    logging.info(f"Running concurrent_eval_driver for {experiment_output_root}")

    logging.info(f"Running 'python concurrent_eval_driver.py {experiment_output_root}'")

    p = subprocess.run(["", "", experiment_output_root])

    if p.returncode != 0:

        logging.error(f"Error in {experiment_output_root}, return code {p.returncode}")    

    else:

        logging.info(f"Experiment {experiment_output_root} completed with return code 0")

    

if __name__ == '':

    main(DIRECTORY_PATHS)
