






import sys

import glob 

import os

import subprocess

import traceback



if __name__ == '':

    

    tc_dir = sys.argv[1]

    timeout = int(sys.argv[2])

    verbose = sys.argv[3].lower() == '' if len(sys.argv) > 3 else False

    n_test_cases = int(sys.argv[4]) if len(sys.argv) > 4 else -1

    open_ended = sys.argv[5].lower() == '' if len(sys.argv) > 5 else False

    if verbose:

        print(f"tc_dir: {tc_dir}, timeout: {timeout}, verbose: {verbose}, n_test_cases: {n_test_cases}, open_ended: {open_ended}")

    

    

    input_files = glob.glob(os.path.join(tc_dir, ''))

    

    input_files = sorted(input_files)

    soln_printed = False

    already_errored = False

    

    

    for i, input_file in enumerate(input_files):

        output_file = input_file.replace('', '') 

        soln_file = os.path.join(tc_dir, '')

        

        

        

        

        

        

        

        

        

        if already_errored: 

            with open(output_file, '') as f:

                

                f.write("")

            continue

        

        try: 

            if open_ended:

                p = subprocess.run(['', soln_file, input_file, output_file], stdout=subprocess.PIPE, stderr=subprocess.PIPE, timeout=timeout)

            else: 

                p = subprocess.run(['', soln_file], stdin=open(input_file, ''), stdout=open(output_file, ''), stderr=subprocess.PIPE, timeout=timeout)

            if p.returncode != 0:

                err = p.stderr.decode('')

                if verbose:

                    print(f'Error running {soln_file} < {input_file} > {output_file}')

                    print(err)

                    if not soln_printed:

                        with open(soln_file, '') as f:

                            print(f.read())

                            soln_printed = True

                if "" in err: 

                    already_errored = True

                    with open(output_file, '') as f:

                        f.write("")

                else:

                    already_errored = True

                    with open(output_file, '') as f:

                        f.write("")

                        

                        

        except subprocess.TimeoutExpired:

            if verbose:

                print(f'Timeout running {soln_file} < {input_file} > {output_file}')

            with open(output_file, '') as f:

                f.write("")

            already_errored = True

                

        except Exception as e:

            if verbose:

                print(f'Error running {soln_file} < {input_file} > {output_file}')

            traceback.print_exc()

            raise e

        

        else:

            if verbose:

                print(f'Finished running {soln_file} < {input_file} > {output_file}')

                

    

        

        

    

    

    

    
