




""""""



import ast

import builtins  

















class Frame:

    """"""



    __slots__ = ["", "", "", ""]



    def __init__(self, source=None, parent=None, children=None, ids=None) -> None:

        self.source = source

        self.parent = parent

        self.children = children or []

        self.ids = ids or {}



    def __str__(self):

        return (

            ""

            + str(self.source.__class__.__name__ + "" if self.source else "")

            + ""

            + "".join([s + "" + str(i) for s, i in self.ids.items()])

            + ""

            + ("" if len(self.children) else "")

            + (

                "".join("".join([str(s) for s in self.children]).split(""))

                if self.children

                else ""

            )

        )



    def __repr__(self):

        return str(self)



    def addFrame(self, frame):

        """"""

        assert isinstance(frame, Frame)

        assert frame != self



        self.children.append(frame)

        frame.parent = self



    def addEntry(self, frameEntry):

        """"""

        assert isinstance(frameEntry, FrameEntry)

        if frameEntry.id in self.ids:

            

            

            

            

            

            return



        self.ids[frameEntry.id] = frameEntry

        frameEntry.parent = self



    def getStack(self):

        """"""

        frames = [self]

        frame = frames[0].parent

        while frame:

            frames.insert(0, frame)

            frame = frames[0].parent

        return frames



    def getScopedEntry(self, frameEntryId):

        """"""

        for frame in reversed(self.getStack()):

            if frameEntryId in frame.ids:

                entry = frame.ids[frameEntryId]

                if isinstance(entry.source, (ast.Global)):

                    

                    

                    return entry.scopeParent.ids[entry.id]

                if isinstance(entry.ctx, ast.Store) and not isinstance(

                    entry.source, (ast.Global, ast.Nonlocal)

                ):

                    

                    

                    return entry



        

        

        

        return None



    def findEntryAtStack(self, nodeStack, frameEntryId):

        """"""

        

        

        return self.getFrameStack(nodeStack)[-1].getScopedEntry(frameEntryId)



    def getAllIds(self):

        """"""

        ids = []

        for frame in reversed(self.getStack()):

            ids += frame.ids.keys()

        return ids



    def getFrameStack(self, nodeStack):

        """"""

        

        

        

        

        frameStack = [self]

        for node in filter(Frame.nodeCreatesFrame, nodeStack):

            frame = frameStack[-1]

            frame = next(filter(lambda f: f.source == node, frame.children))

            frameStack.append(frame)

        return frameStack



    @staticmethod

    def nodeCreatesFrame(node):

        """"""

        

        return isinstance(node, (ast.FunctionDef, ast.ClassDef, ast.Module))



    @staticmethod

    def getBuiltinFrame():

        """"""

        frame = Frame()

        for b in dir(builtins) + [""]:

            frame.addEntry(FrameEntry(b))

        return frame





class FrameEntry:

    """"""



    __slots__ = ["", "", "", "", "", ""]



    def __init__(

        self, id, source=None, ctx=ast.Store(), scope=None, value=None

    ) -> None:

        self.source = source

        self.ctx = ctx

        self.value = value

        self.id = id

        self.scopeParent = scope

        self.parent = None  



    def __str__(self):

        return (

            str(self.source.__class__.__name__)

            + (("" + str(self.ctx.__class__.__name__) + "") if self.ctx else "")

            + (("" + str(self.value)) if self.value else "")

        )



    def __repr__(self):

        return str(self)





def getIdsFromNode(node):

    """"""

    

    if isinstance(node, (ast.Global, ast.Nonlocal)):

        return node.names

    

    elif isinstance(node, ast.alias):

        return [node.name if node.asname is None else node.asname]

    

    elif isinstance(node, ast.ExceptHandler):

        

        return [node.name] if hasattr(node, "") and type(node.name) == str else []

    

    elif isinstance(node, (ast.FunctionDef, ast.ClassDef)):

        return [node.name]

    

    

    

    elif isinstance(node, ast.arguments):

        ret = []

        if hasattr(node, "") and type(node.args) == str:

            ret.append(node.args)

        if hasattr(node, "") and type(node.kwargs) == str:

            ret.append(node.kwargs)

    

    

    elif isinstance(node, ast.arg):

        return [node.arg] if type(node.arg) == str else []

    

    

    elif isinstance(node, ast.Name):

        return [node.id]

    elif isinstance(node, ast.Attribute):

        return [node.attr]

    return []





def setIdsOnNode(node, names):

    """"""

    if not names:

        return  



    if isinstance(node, (ast.Global, ast.Nonlocal)):

        node.names = names

    elif isinstance(node, (ast.alias)):

        if node.asname is None:

            node.name = names[0]

        else:

            node.asname = names[0]

    elif isinstance(node, (ast.FunctionDef, ast.ClassDef, ast.ExceptHandler)):

        node.name = names[0]

    elif isinstance(node, ast.arguments):

        

        if hasattr(node, "") and type(node.kwargs) == str:

            node.kwargs = names.pop()

        if hasattr(node, "") and type(node.args) == str:

            node.args = names.pop()

    elif isinstance(node, ast.arg):

        node.arg = names[0]

    elif isinstance(node, ast.Name):

        node.id = names[0]

    elif isinstance(node, ast.Attribute):

        node.attr = names[0]

