
""""""

import keyword

import sys

import ast

import string

import unicodedata

import itertools

import logging

from collections import defaultdict

import astunparse



from obfuscation.bobskater_frameUtils import (

    Frame,

    FrameEntry,

    getIdsFromNode,

    setIdsOnNode,

)

from obfuscation.obfuscated_names_generator import (

    ObfuscatedNamesGenerator,

    ObfuscatedNameType,

)





class Struct:

    """"""



    def __init__(self, inputDict) -> None:

        self.__dict__.update(inputDict)





def iter_fields_patch(node):

    """"""

    it = (

        node._fields

        if not isinstance(

            node, (ast.ListComp, ast.SetComp, ast.GeneratorExp, ast.DictComp)

        )

        else reversed(node._fields)

    )

    for field in it:

        try:

            yield field, getattr(node, field)

        except AttributeError:

            pass





ast.iter_fields = iter_fields_patch





def validIdentifierIterator(version=2):

    """"""

    

    if version == 2:

        validIDStart = string.ascii_letters + ""

        validID = string.ascii_letters + "" + string.digits

    else:

        

        

        unicode_category = defaultdict(str)

        for c in map(

            chr, range(min(sys.maxunicode + 1, 20000))

        ):  

            unicode_category[unicodedata.category(c)] += c



        

        validIDStart = (

            unicode_category[""]

            + unicode_category[""]

            + unicode_category[""]

            + unicode_category[""]

            + unicode_category[""]

            + unicode_category[""]

            + ""

        )

        

        validID = (

            validIDStart

            + unicode_category[""]

            + unicode_category[""]

            + unicode_category[""]

            + unicode_category[""]

        )



    

    for c in validIDStart:

        if c in keyword.kwlist:

            continue  

        yield c



    

    tailLength = 1

    while True:

        for c in validIDStart:

            for c2 in itertools.combinations_with_replacement(validID, tailLength):

                c2 = "".join(c2)

                if c + c2 in keyword.kwlist:

                    continue  

                yield c + c2



        tailLength += 1





class FrameTrackingNodeVisitor(ast.NodeVisitor):

    """"""



    def __init__(self, *args, **kwargs) -> None:

        super().__init__(*args, **kwargs)

        self._logger = logging.getLogger(self.__class__.__name__)



        

        

        self._rootFrame = Frame.getBuiltinFrame()

        self._currentFrame = self._rootFrame



    def _handleEnterNode(self, node):

        """"""

        

        

        

        

        

        

        

        



        

        

        

        if isinstance(node, (ast.Global, ast.Nonlocal)):

            

            for strId in node.names:

                

                

                

                

                

                

                



                

                

                

                if self._currentFrame.getScopedEntry(strId) == self._currentFrame:

                    self._logger.warning(

                        ""

                    )

                elif isinstance(node, ast.Nonlocal):

                    

                    

                    self._logger.debug(

                        "" + str(node.__class__.__name__) + '' + strId + ''

                    )

                    

                    self._currentFrame.addEntry(

                        FrameEntry(id=strId, source=node, ctx=ast.Load())

                    )

                else:  

                    

                    self._currentFrame.addEntry(

                        FrameEntry(

                            id=strId,

                            source=node,

                            ctx=ast.Load(),

                            scope=self._rootFrame.children[0],

                        )

                    )

        

        

        elif isinstance(node, ast.Name):

            if isinstance(node.ctx, ast.Load):

                self._logger.debug(

                    "" + str(node.__class__.__name__) + '' + node.id + ''

                )

                self._currentFrame.addEntry(

                    FrameEntry(id=node.id, source=node, ctx=node.ctx)

                )

            

            

            elif isinstance(node.ctx, (ast.Store, ast.Param)):

                self._logger.debug(

                    "" + str(node.__class__.__name__) + '' + node.id + ''

                )

                self._currentFrame.addEntry(

                    FrameEntry(id=node.id, source=node, ctx=ast.Store())

                )

            

            

        

        

        else:

            ids = getIdsFromNode(node)

            for strId in ids:

                self._logger.debug(

                    "" + str(node.__class__.__name__) + '' + strId + ''

                )

                self._currentFrame.addEntry(FrameEntry(id=strId, source=node))



        if Frame.nodeCreatesFrame(node):

            frame = Frame(source=node)

            self._currentFrame.addFrame(frame)

            self._currentFrame = frame



            self._logger.debug(

                ""

                + str(node.__class__.__name__)

                + ''

                + (node.name if hasattr(node, "") else "")

                + ''

            )



    def _handleLeaveNode(self, node):

        """"""

        if Frame.nodeCreatesFrame(node):

            self._logger.debug("")

            self._currentFrame = self._currentFrame.parent



    def generic_visit(self, node):

        self._handleEnterNode(node)

        super().generic_visit(node)

        self._handleLeaveNode(node)



    def getRootFrame(self):

        return self._rootFrame





class ObfuscationTransformer(ast.NodeTransformer):

    """"""



    def __init__(

        self,

        rootFrame,

        *args,

        removeDocstrings=True,

        obfuscateNames=True,

        debug=False,

        **kwargs,

    ):

        self._logger = logging.getLogger(self.__class__.__name__)

        self.debug = debug

        self._rootFrame = rootFrame

        self._nodeStack = []

        self._debugMsg = None

        self._opt = Struct(

            {"": removeDocstrings, "": obfuscateNames}

        )

        self.names_generator = ObfuscatedNamesGenerator()



        

        

        

        self._name = validIdentifierIterator()

        super().__init__(*args, **kwargs)



    def getMangledName(self, nodeStack, strId, node):

        """"""

        frameEntry = self._rootFrame.findEntryAtStack(nodeStack, strId)

        if frameEntry is None:

            return False

        isBuiltin = frameEntry.parent == self._rootFrame



        alreadyMangledName = frameEntry.value

        if alreadyMangledName:

            if isinstance(node, ast.Attribute):

                try:

                    parent = node.value.id

                    if (

                        parent == ""

                        or parent.startswith("")

                        or parent.startswith("")

                    ):

                        return alreadyMangledName

                except AttributeError:

                    return False

            else:

                self._debugMsg = '' + alreadyMangledName + ''

                return alreadyMangledName  

        if alreadyMangledName is False:

            self._debugMsg = ""

            return False  



        if isBuiltin:

            

            self._debugMsg = ""

            frameEntry.value = False

            return False



        if strId.startswith("") and strId.endswith(""):

            

            frameEntry.value = False

            return False



        stackNode = (

            frameEntry.parent.source

        )  

        sourceNode = node  

        

        

        

        

        

        

        

        if isinstance(sourceNode, ast.alias):

            

            self._debugMsg = ""

            frameEntry.value = False

            return False

        elif (

            isinstance(sourceNode, ast.arg)

            and hasattr(nodeStack[-1], "")

            and nodeStack[-1].defaults

        ):

            self._debugMsg = ""

            

            

            

            argumentsNode = nodeStack[-1]

            

            kwStrs = list(

                map(lambda n: n.arg, argumentsNode.args[-len(argumentsNode.defaults) :])

            )

            if self.debug:

                self._logger.debug(

                    "", kwStrs, strId, strId in kwStrs

                )

            if strId in kwStrs:

                frameEntry.value = False

                return False



        

        

        

        ids = frameEntry.parent.getAllIds()

        if isinstance(sourceNode, ast.ClassDef):

            mangledName = self.names_generator.get_new_name(

                sourceNode.name, ObfuscatedNameType.CLASS

            )

        elif isinstance(sourceNode, ast.FunctionDef):

            mangledName = self.names_generator.get_new_name(

                sourceNode.name, ObfuscatedNameType.FUNCTION

            )

        elif isinstance(sourceNode, ast.arg):

            mangledName = self.names_generator.get_new_name(

                sourceNode.arg, ObfuscatedNameType.VARIABLE

            )

        elif isinstance(sourceNode, ast.Name):

            mangledName = self.names_generator.get_new_name(

                sourceNode.id, ObfuscatedNameType.VARIABLE

            )

        elif isinstance(sourceNode, ast.Attribute):

            oldname = sourceNode.attr

            try:

                parent = sourceNode.value.id

                if (

                    parent == ""

                    or parent.startswith("")

                    or parent.startswith("")

                ):

                    if self.names_generator.function_is_obfuscated(oldname):

                        

                        mangledName = self.names_generator.get_new_name(

                            oldname, ObfuscatedNameType.FUNCTION

                        )

                    else:

                        mangledName = self.names_generator.get_new_name(

                            oldname, ObfuscatedNameType.VARIABLE, isAttribute=True

                        )

                else:

                    

                    return False

            except AttributeError:

                return False



        frameEntry.value = mangledName

        return mangledName



    def generic_visit(self, node):

        

        if (

            self._opt.removeDocstrings

            and isinstance(node, ast.Expr)

            and isinstance(

                self._nodeStack[-1], (ast.FunctionDef, ast.ClassDef, ast.Module)

            )

            and isinstance(node.value, ast.Str)

        ):

            return ast.Pass()



        

        ids = getIdsFromNode(node)

        if self._opt.obfuscateNames:

            if self.debug:

                oldIds = ids[:]

            for idx, strId in enumerate(ids):

                mangleTo = self.getMangledName(self._nodeStack, strId, node)

                if not mangleTo:

                    continue

                ids[idx] = mangleTo

            setIdsOnNode(node, ids)

            if ids and self.debug:

                self._logger.debug(

                    node.__class__.__name__

                    + ""

                    + (str(oldIds) if oldIds else None)

                    + ""

                    + (str(ids) if ids else None)

                    + ""

                    + str(self._debugMsg)

                    + ""

                )

                self._debugMsg = ""



        

        self._nodeStack.append(node)

        super().generic_visit(node)

        self._nodeStack.pop()



        return node





def obfuscateString(s, *args, **kwargs):

    

    sAst = ast.parse(s)

    

    ftnv = FrameTrackingNodeVisitor()

    ftnv.visit(sAst)

    logging.getLogger(__name__).debug(ftnv.getRootFrame())

    

    

    transformer = ObfuscationTransformer(ftnv.getRootFrame(), *args, **kwargs)

    sAst = transformer.visit(sAst)

    

    return astunparse.unparse(sAst), transformer.names_generator.get_dictionary()





def inverse_dico(d):

    return {v: k for k, v in d.items()}





def merge_dico_in_first(d1, d2):

    """"""

    for k, v in d2.items():

        if k in d1:

            raise ValueError(f"Key {k} should not be in d1")

        else:

            d1[k] = v

    return d1





def obfuscateFile(fp, *args, **kwargs):

    f = open(fp, "")

    s = f.read()

    f.close()

    s = obfuscateString(s, *args, **kwargs)

    f = open(fp, "")

    f.write(s)

    f.close()





if __name__ == "":

    iterative_factorial = """"""



    factorial = """"""

    res = obfuscateString(

        iterative_factorial, obfuscateNames=True, removeDocstrings=False

    )

    print(res)

