














import javalang

from codegen_sources.preprocessing.obfuscation.obfuscated_names_generator import (

    ObfuscatedNamesGenerator,

    ObfuscatedNameType,

)

from javalang.tokenizer import Identifier, Position



EXCLUDED_TOKENS = {""}





def obfuscate(java_program):

    tokens = list(javalang.tokenizer.tokenize(java_program))

    declarations, declarations_per_vartype, calls_to_replace = get_variable_usages(

        java_program

    )

    names_generator = ObfuscatedNamesGenerator()



    

    for token_name, dec_list in declarations.items():

        for dec_info in dec_list:

            dec_position = dec_info[""]



            

            for i, tok in enumerate([t for t in tokens if t.position >= dec_position]):

                if tok.value == token_name:

                    tok.value = names_generator.get_new_name(

                        token_name, dec_info[""]

                    )

                    

                    dec_info[""] = tok.value

                    break



    calls_to_replace_index = 0

    for current_tok_index, tok in enumerate(tokens):

        if calls_to_replace_index < len(calls_to_replace):

            

            current_call_to_replace = calls_to_replace[calls_to_replace_index]

            assert current_call_to_replace[""] in ObfuscatedNameType

            relevant_declarations = declarations_per_vartype[

                current_call_to_replace[""]

            ][current_call_to_replace[""]]

            assert (

                len(relevant_declarations) > 0

            ), ""

            if tok.position >= current_call_to_replace[""]:

                calls_to_replace_index += 1

                for advanced_tok_index in range(current_tok_index, len(tokens)):

                    if (

                        tokens[advanced_tok_index].value

                        == current_call_to_replace[""]

                    ):

                        if (

                            current_call_to_replace[""]

                            == ObfuscatedNameType.FUNCTION

                        ):

                            if current_call_to_replace[""] is None:

                                

                                is_replace_candidate = (

                                    advanced_tok_index == 0

                                    or tokens[advanced_tok_index - 1].value != ""

                                )

                            else:

                                

                                qualifier_split = current_call_to_replace[

                                    ""

                                ].split("")

                                is_replace_candidate = advanced_tok_index > 2 * len(

                                    qualifier_split

                                )

                                for i, qual in enumerate(qualifier_split[::-1]):

                                    is_replace_candidate = (

                                        is_replace_candidate

                                        and tokens[

                                            advanced_tok_index - (2 * i + 1)

                                        ].value

                                        == ""

                                        and tokens[

                                            advanced_tok_index - (2 * i + 2)

                                        ].value

                                        == qual

                                    )

                            if is_replace_candidate:

                                tokens[

                                    advanced_tok_index

                                ].value = relevant_declarations[0][""]



        

        if isinstance(tok, Identifier) and tok.value in declarations:

            token_declarations = declarations[tok.value]

            tok_position = tok.position

            previous_declarations = [

                dec

                for dec in token_declarations

                if dec[""] < tok_position and "" in dec

            ]

            if (

                current_tok_index >= 2

                and tokens[current_tok_index - 1].value == ""

                and tokens[current_tok_index - 2].value == ""

            ):

                previous_declarations = [

                    dec for dec in previous_declarations if dec[""]

                ]

                if len(previous_declarations) == 0:

                    

                    previous_declarations = [

                        dec for dec in token_declarations if dec[""]

                    ]



            relevant_declaration = None

            if len(previous_declarations) == 0:

                class_declarations = declarations_per_vartype[ObfuscatedNameType.CLASS][

                    tok.value

                ]

                if len(class_declarations) > 0:

                    relevant_declaration = class_declarations[0]

                else:

                    func_declarations = declarations_per_vartype[

                        ObfuscatedNameType.FUNCTION

                    ][tok.value]

                    if len(func_declarations) > 0:

                        relevant_declaration = func_declarations[0]

            else:

                relevant_declaration = previous_declarations[-1]

            if relevant_declaration is not None:

                tok.value = relevant_declaration[""]



    res_lines = [[]]

    prev_line = 0

    for tok in tokens:

        if tok.position.line > prev_line:

            res_lines.append([])

            prev_line = tok.position.line

        res_lines[-1].append(tok.value)



    return (

        "".join(["".join(line) for line in res_lines]),

        names_generator.get_dictionary(),

    )





def is_position_greater(position1, position2):

    return position1.line > position2.line or (

        position1.line == position2.line and position1.position > position2.position

    )





def is_position_equal(position1, position2):

    return position1.line == position2.line and position1.position == position2.position





def is_position_greater_or_equal(position1, position2):

    return is_position_greater(position1, position2) or is_position_equal(

        position1, position2

    )





def get_variable_usages(java_program):

    declarations = {}

    calls_to_replace = []

    ast = javalang.parse.parse(java_program)



    previous_position = Position(0, 0)

    for path, node in ast:

        

        if (

            isinstance(node, javalang.tree.ClassDeclaration)

            or isinstance(node, javalang.tree.InterfaceDeclaration)

            or isinstance(node, javalang.tree.EnumDeclaration)

        ):

            declarations, previous_position = add_declaration_node(

                node.name,

                node.position,

                ObfuscatedNameType.CLASS,

                declarations,

                previous_position,

            )

        if isinstance(node, javalang.tree.MethodDeclaration):

            declarations, previous_position = add_declaration_node(

                node.name,

                node.position,

                ObfuscatedNameType.FUNCTION,

                declarations,

                previous_position,

            )

        if (

            isinstance(node, javalang.tree.LocalVariableDeclaration)

            or isinstance(node, javalang.tree.VariableDeclaration)

            or isinstance(node, javalang.tree.FieldDeclaration)

        ):

            for name in [d.name for d in node.declarators]:

                declarations, previous_position = add_declaration_node(

                    name,

                    node.position,

                    ObfuscatedNameType.VARIABLE,

                    declarations,

                    previous_position,

                    decl_type=node.type.name,

                    is_field=isinstance(node, javalang.tree.FieldDeclaration),

                )

        if isinstance(node, javalang.tree.FormalParameter) or isinstance(

            node, javalang.tree.EnumConstantDeclaration

        ):

            declarations, previous_position = add_declaration_node(

                node.name,

                node.position,

                ObfuscatedNameType.VARIABLE,

                declarations,

                previous_position,

            )



        if isinstance(node, javalang.tree.MethodInvocation):

            calls_to_replace, previous_position = add_node_to_replace(

                node.member,

                node.position,

                ObfuscatedNameType.FUNCTION,

                calls_to_replace,

                previous_position,

                qualifier=node.qualifier,

            )

        if isinstance(node.position, Position):

            previous_position = node.position



    for i in range(len(calls_to_replace) - 1):

        assert calls_to_replace[i][""] <= calls_to_replace[i + 1][""]

    declarations_per_vartype = {}

    for vartype in ObfuscatedNameType:

        declarations_per_vartype[vartype] = {

            k: [dec for dec in v if dec[""] == vartype]

            for k, v in declarations.items()

        }

    calls_to_replace = [

        call

        for call in calls_to_replace

        if len(declarations_per_vartype[call[""]].get(call[""], [])) > 0

    ]

    return declarations, declarations_per_vartype, calls_to_replace





def add_declaration_node(

    name,

    position,

    var_type,

    declarations,

    previous_position,

    decl_type=None,

    is_field=False,

):

    if position is None:

        new_positions = Position(previous_position.line, previous_position.column + 1)

        position = previous_position

    else:

        new_positions = position

    if name in EXCLUDED_TOKENS:

        return declarations, position



    declarations[name] = declarations.get(name, []) + [

        {

            "": new_positions,

            "": var_type,

            "": decl_type,

            "": is_field,

        }

    ]

    return declarations, position





def add_node_to_replace(

    name, position, var_type, to_replace, previous_position, qualifier=None

):

    if position is None:

        new_positions = Position(previous_position.line, previous_position.column + 1)

        position = previous_position

    else:

        new_positions = position



    if name in EXCLUDED_TOKENS:

        return to_replace, position

    to_replace.append(

        {

            "": name,

            "": new_positions,

            "": var_type,

            "": qualifier,

        }

    )

    return to_replace, position

