
import re



def vanilla_template(description):

    verbalized = f"Generate a program completion in python for the given function description: {description}"

    return verbalized



def code_template(program):

    generated_code_squared = f"""
import sys

{program} """ + """"""

    return generated_code_squared



def extract_and_remove_multiline_comments(code):

    

    triple_double_quotes_pattern = rr

    triple_single_quotes_pattern = rr



    

    extracted_comments = []



    

    extracted_comments.extend(re.findall(triple_double_quotes_pattern, code, flags=re.DOTALL))

    cleaned_code = re.sub(triple_double_quotes_pattern, '', code, flags=re.DOTALL)



    

    extracted_comments.extend(re.findall(triple_single_quotes_pattern, cleaned_code, flags=re.DOTALL))

    cleaned_code = re.sub(triple_single_quotes_pattern, '', cleaned_code, flags=re.DOTALL)



    extracted_comments = '' + "".join(extracted_comments) + '' if extracted_comments else ""

    

    return extracted_comments, cleaned_code





block_patterns = re.compile(rr, re.VERBOSE)









block_patterns_allow_addtl = re.compile(rr, re.VERBOSE)

                                

    

def extract_python_code(text):

    import ast 

    import re

    

    

    

    

    multiline_comments, text = extract_and_remove_multiline_comments(text)

    text = re.sub(rr, "", text)

    text = re.sub(rr, "", text)

    lines = text.splitlines()

    python_code = multiline_comments + ""

    block = ""

    block_active = False

    previous_indent = 0



    for line_idx, line in enumerate(lines):

        

        

        stripped_line = re.sub(rr, '', line)  

        stripped_line = stripped_line.lstrip() 

        leading_spaces = len(line) - len(stripped_line)



        

        

        if not block_active and not stripped_line:

            python_code += line + ""

            continue

        

        if block_patterns.match(stripped_line):

            if not block_active or leading_spaces > previous_indent:



                if not block_active: 

                    previous_indent = leading_spaces

                block_active = True

            block += line + ""

            continue

        

        

        if block_active and (leading_spaces > previous_indent or not stripped_line):

            block += line + ""

            continue

        

        else:

            

            if block_active:

                

                lines = block.splitlines()

                block = "".join([line[previous_indent:] for line in lines])

                

                python_code += block.strip() + ""

                block = ""

                block_active = False

        



        

        if re.match(rr, stripped_line) and not block_active:

            python_code += stripped_line + ""

            continue        



        

        if not block_active and stripped_line and not stripped_line.startswith(''):

            

            

            try: 

                parsed_node = ast.parse(stripped_line).body

                if parsed_node: 

                    if not (isinstance(parsed_node[0], ast.Expr) and isinstance(parsed_node[0].value, ast.Name)):

                        python_code += line + ""

                        continue

            except (SyntaxError, IndexError, MemoryError, ValueError):

                pass

            

            

            

            

            try: 

                if block_patterns_allow_addtl.match(stripped_line):

                    block_pattern_sub = re.sub("", "", stripped_line)

                    parsed_node = ast.parse(block_pattern_sub).body

                    if (isinstance(parsed_node[0], ast.Expr) and not isinstance(parsed_node[0].value, ast.Name)):

                        

                        if line_idx + 1 >= len(lines):

                            python_code += line + ""

                        else: 

                            next_line = lines[line_idx + 1]

                            next_stripped_line = re.sub(rr, '', next_line).lstrip()

                            next_leading_spaces = len(next_line) - len(next_stripped_line)

                            if next_leading_spaces <= leading_spaces:

                                python_code += line + ""

                                continue

                        

            except (SyntaxError, IndexError, MemoryError):

                pass

                        

            

            

        

            

        



        



    

    if block_active and block:

        lines = block.splitlines()

        block = "".join([line[previous_indent:] for line in lines])

        python_code += block.strip() + ""



    return python_code.strip()

    

    

    

    

    



















    











        









        











































                

































































