
import matplotlib.pyplot as plt

import pandas as pd

import matplotlib.patches as mpatches

import numpy as np





INCLUDE_BASE_MODELS = True  

INCLUDE_DEEPSEEK_CODER = True  



file_paths = [

    "",

    "",

    "",

    "",

    "",

    "",

    "", 

    "",

]



dfs = []

for file_path in file_paths:

    df = pd.read_csv(file_path, sep="")

    dfs.append(df)





df = pd.concat(dfs)





df[""] = df[""].str.extract(rr, expand=False)

df[""] = df[""].str.replace("", "").str.replace("", "").astype(float)





df = df[df[""] == 1.0]

df = df[df[""] == 1.0]

df = df[df[""] != ""]

df = df.drop_duplicates(subset=[""], keep="")

df[""] = df[""].astype(float)

df[["", "", ""]].to_csv("", sep="", index=False)





model_alignment_map = {

    

    "": "",

    "": "",

    "": "",

    "": "",

    "": "",

    

    

    "": "",

    "": "",

    "": "",

    "": "",

    "": "",

    "": "",

    

    

    "": "",

    "": "",

    "": "",

    "": "",

    

    

    "": "",

    "": "",

    "": "",

    "": "",

    

    

    "": "",

    "": "",

    "": "",

    "": "",

    

    

    "": "",

    "": "",

    "": "",

    "": "",

    "": "",

    "": "",

    

    

    "": "",

    "": "",

    "": "",

    "": "",

    "": ""

}





df[""] = ""

df.loc[df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains("") & ~df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains(""), ""] = ""

df.loc[df[""].str.contains(""), ""] = ""





def create_clean_name(row):

    family = row[""]

    size = f"{row['']:.1f}B".replace("", "")

    alignment = model_alignment_map.get(row[""], "")

    

    if alignment == "":

        align_suffix = ""

    elif alignment == "":

        align_suffix = ""

    elif alignment == "":

        align_suffix = ""

    elif alignment == "":

        align_suffix = ""

    elif alignment == "":

        align_suffix = ""

    else:

        align_suffix = f" ({alignment})"

    

    return f"{family} {size}{align_suffix}"



df[""] = df.apply(create_clean_name, axis=1)

df[""] = df[""].map(model_alignment_map)



df[""] = df[""].fillna("")





if not INCLUDE_BASE_MODELS:

    df = df[df[""] != ""]



if not INCLUDE_DEEPSEEK_CODER:

    df = df[~df[""].str.contains("")]





family_marker_map = {

    "": "",     

    "": "",       

    "": "",        

    "": "",        

    "": "",       

    "": "", 

    "": "",   

    "": "", 

    "": ""          

}





alignment_color_map = {

    "": "",    

    "": "",     

    "": "",     

    "": "",      

    "": "", 

    "": ""  

}





df[""] = df[""] / df[""]





plt.figure(figsize=(12, 8))





legend_entries = {}





for idx, row in df.iterrows():

    alignment = row[""]

    family = row[""]

    

    

    if alignment not in legend_entries:

        label = alignment.upper()

        legend_entries[alignment] = True

    else:

        label = None  

    

    

    plt.scatter(

        row[""], 

        row[""],

        marker=family_marker_map.get(family, ""),

        color=alignment_color_map.get(alignment, ""),

        s=150,  

        alpha=0.9,

        label=label

    )





size_counts = df.groupby("").size()

size_index = {size: 0 for size in df[""].unique()}





for idx, row in df.iterrows():

    current_idx = size_index[row[""]]

    size_index[row[""]] += 1

    

    

    offset_x = row[""] * 0.1

    

    

    total_in_group = size_counts[row[""]]

    

    if total_in_group > 1:

        

        vertical_offset = 0.2 * current_idx  

        new_y = row[""] * (1 + vertical_offset)

    else:

        new_y = row[""] * 1.15  

    

    

    label_text = row[""].split()[0] + "" + row[""].split()[1]

    plt.annotate(

        label_text,

        (row[""], row[""]),

        xytext=(row[""] + offset_x, new_y),

        fontsize=9,

        fontweight='',

        alpha=0.9,

        arrowprops=dict(arrowstyle='', lw=0.5, alpha=0.6)

    )





plt.xlabel("", fontsize=14, weight='')

plt.ylabel("", fontsize=14, weight='')





plt.xscale("")

plt.yscale("")





sizes = sorted(df[""].unique())

plt.xticks(sizes, [f"{s:.1f}B".replace("", "") for s in sizes], fontsize=12)

plt.yticks(fontsize=12)





plt.grid(True, alpha=0.3, linestyle='')





title = ""

if not INCLUDE_BASE_MODELS:

    title += ""

if not INCLUDE_DEEPSEEK_CODER:

    title += ""

plt.title(title, fontsize=16, weight='')





handles, labels = plt.gca().get_legend_handles_labels()

plt.legend(handles, labels, loc='', title="", 

          fontsize=12, title_fontsize=14)





plt.box(True)





plt.savefig("", dpi=300, bbox_inches='')





print(f"Total models plotted: {len(df)}")

print(f"Models by alignment method:")

print(df.groupby("").size())
