
import openai 

from tenacity import * 

import json 



import openai 

PATH_TO_KEY=""

with open(PATH_TO_KEY, '') as f:

    key = f.read().strip()

PATH_TO_ORG=""

with open(PATH_TO_ORG, '') as f:

    org = f.read().strip()

openai.organization = org

openai.api_key = key



default_model = ""



@retry(

    stop=stop_after_attempt(10),

    retry=retry_if_exception_type((openai.error.APIConnectionError, openai.error.APIError, json.JSONDecodeError)),

)

def get_general_response(prompt, model=default_model, temperature=1.0, n=1, top_p=1.0): 

  completion = openai.ChatCompletion.create(

    model = model,

    messages = [

      {'': '', '': ''},

      {'': '', '': f'{prompt}'}

    ],

    temperature = temperature,

    n=n,

    top_p=top_p

  )

  return [c[""][""] for c in completion[""]]



    





example_problem = """"""



example_input = """"""



example_tcgen = """"""



example_extract_arguments = """"""





def prompt_gpt_to_generate_input_description(new_problem_statement, orig_problem_statement, orig_input_description, model=default_model, temperature=0.5, n=1, top_p=1.0):

    prompt = f"""
    Can you extract and also canonicalize the input specification for this competitive programming problem? 
    To canonicalize, make the input specification broad to the input types and ranges, and disassociate it from the 
    problem description itself. Ideally, include a short example of simple inputs as a string that will be read in from a file / stdin.
    And also include a function signature that processes all the inputs (do not specify the output type, just the inputs).
    If the inputs can be a tuple: for example, (N, A, C), then please include a function signature that processes the tuple, f(N, A, C). 
    If the inputs are a list of such tuples, then include a function signature that processes the list of tuples, f(inputs). 
    Here is an example of a problem statement and input description:
    Problem Statement:
    {orig_problem_statement}
    Canonicalized Input Description: 
    {orig_input_description}
    
    Here is a the problem statement that you need to extract the input description from:
    Problem Statement:
    {new_problem_statement}
    Now, please extract and canonicalize the input description, please try to anonymize and obfuscate away anything related to the problem statement
    and only mention the ranges/types of the input. 
    """

    return get_general_response(prompt, model=model, temperature=temperature, n=n, top_p=top_p)





def prompt_gpt_to_write_testcase_generator(new_problem_statement, orig_problem_statement, orig_tcgen, model=default_model, temperature=0.5, n=1, top_p=1.0):

    prompt = f"""
    Can you write a test case generator for this competitive programming problem? 
    Here is an example of a problem statement and test case generator:
    Problem Statement:
    {orig_problem_statement}
    Test Case Generator:
    {orig_tcgen}
    
    Here is a the problem statement that you need to write a test case generator for:
    Problem Statement:
    {new_problem_statement}
    """

    return get_general_response(prompt, model=model, temperature=temperature, n=n, top_p=top_p)



def prompt_gpt_to_write_extract_arguments(new_problem_statement, orig_problem_statement, orig_extract_arguments, model=default_model, temperature=0.5, n=1, top_p=1.0):

    prompt = f"""
    Can you write a function to extract the arguments from the input file for this competitive programming problem? 
    Then also write the function that processes the arguments. 
    If the inputs can be a tuple: for example, (N, A, C), then please include a function signature that processes the tuple, f(N, A, C).
    If the inputs are a list of such tuples, then include a function signature that processes the list of tuples, f(inputs).
    Here is an example of a problem statement and extract arguments function:
    Problem Statement:
    {orig_problem_statement}
    Extract Arguments Function:
    {orig_extract_arguments}
    
    Here is a the problem statement that you need to write an extract arguments function for:
    Problem Statement:
    {new_problem_statement}
    """

    return get_general_response(prompt, model=model, temperature=temperature, n=n, top_p=top_p)

  

def format_html(orig_description, specification, tcgen, extract_args, problem_no="", generation=""): 

    html_template = """"""



    return html_template.format(orig_description=orig_description, specification=specification, tcgen=tcgen, 

                                problem_no=problem_no, generation=generation, extract_args=extract_args)























































def make_n_html_from_programs(new_description, n, temp, top_p, model=default_model, example_problem=example_problem, example_input=example_input, example_tcgen=example_tcgen, problem_no=""):

    n_input_descriptions = prompt_gpt_to_generate_input_description(new_description, example_problem, example_input, model=model, temperature=temp, n=n, top_p=top_p)

    n_tc_gens = prompt_gpt_to_write_testcase_generator(new_description, example_problem, example_tcgen, model=model, temperature=temp, n=n, top_p=top_p)

    n_extract_args = prompt_gpt_to_write_extract_arguments(new_description, example_problem, example_extract_arguments, model=model, temperature=temp, n=n, top_p=top_p)

    

    html_outputs = [format_html(new_description, n_input_descriptions[i], n_tc_gens[i], n_extract_args[i], problem_no=problem_no, generation=str(i+1)) for i in range(n)]

    return html_outputs, n_input_descriptions, n_tc_gens, n_extract_args

  

  

def print_model_list(): 

    response = openai.Model.list()



    

    for model in response[""]:

        print(model[""])
