import platform
import psutil
import sys
import subprocess

def get_cpu_info():
    print(f"CPU: {platform.processor()}")
    print(f"CPU cores (physical): {psutil.cpu_count(logical=False)}")
    print(f"CPU cores (total): {psutil.cpu_count(logical=True)}")

def get_memory_info():
    mem = psutil.virtual_memory()
    print(f"Total Memory: {mem.total / (1024 ** 3):.2f} GB")

def get_gpu_info():
    try:
        # Try using NVIDIA System Management Interface
        output = subprocess.check_output(["nvidia-smi"], encoding="utf-8")
        print("GPU Info (from nvidia-smi):")
        print(output)
    except Exception as e:
        print("No GPU found or nvidia-smi not installed.")

def get_python_info():
    print(f"Python version: {platform.python_version()}")
    print(f"Python build: {platform.python_build()}")

def main():
    print("=== Environment Information ===")
    get_python_info()
    get_cpu_info()
    get_memory_info()
    get_gpu_info()

if __name__ == "__main__":
    main()
