# CNN Kernels Can Be the Best Shapelets

This repo provides the official implementation of the ShapeConv layer.

## Requirements

The required packages are:
- PyTorch
- Numpy
- Sklearn
- Sktime

## Usage

First, download UCR dataset and UEA dataset from [here](http://www.timeseriesclassification.com/dataset.php) and put them in `data/UCR` and `data/UEA` respectively.

To train the model(s) in the paper, use the `train.py` with different arguments. For example, for the supervised time-series classification task on the univariate UCR dataset, run this command:

```bash
python train.py --dir logs --dataset GunPoint --task S --var U --num_class 2 --init class --l 3 --d 2 --hid 32 --epochs 1000 --seed 10 --lr 0.05 --lam_div 0.01 --lam_shape 0.1 --batch_size 32 --cuda 0
```

For the supervised time-series classification task on the multivariate UEA dataset, run this command:

```bash
python train.py --dir logs --dataset BasicMotions --task S --var M --num_class 4 --init class --l 3 --d 2 --hid 32 --epochs 1000 --seed 10 --lr 0.05 --lam_div 0.01 --lam_shape 0.1 --batch_size 32 --cuda 0
```

More explanation of the arguments can be found in the next section.

## Files

- `train.py`: the main file to run the experiments. Arguments:
    - `--dir`: the directory to save the logs.
    - `--dataset`: the name of the dataset.
    - `--task`: the task to run. `S` for supervised time-series classification, `U` for unsupervised time-series clustering.
    - `--var`: the type of the data. `U` for univariate, `M` for multivariate.
    - `--init`: the initialization method. `class` for class-based initialization, `cut` for cut and sample initialization. `normal` for random normal initialization.
    - `--l`: kernel size = dataset length / l.
    - `--d`: dim = num_class * d.
    - `--hid`: the number of hidden neurons.
    - `--epochs`: the number of epochs to train.
    - `--lr`: the learning rate.
    - `--lam_div`: the weight of the diversity regularizer.
    - `--lam_shape`: the weight of the shape regularizer.
    - `--batch_size`: the batch size.
    - `--cuda`: the GPU ID to use.
- `Model/shapeconv_univariate.py`: the ShapeConv layer for univariate time-series.
- `Model/shapeconv_multivariate.py`: the ShapeConv layer for multivariate time-series.
- `dataset.py`: the dataset class.
- `utils.py`: some utility functions. Including DBI loss and NMI calculation.