
def load_model(model, *args, **kwargs):
    """
    Returns a triple of (model, vis_processor, text_processor). If your model does not require any of these, you may return None
    """
    # Lazy load models, due to different requirements
    if model == "videollama2":
        from models import VideoLLaMA2
        return VideoLLaMA2.load_model(*args, **kwargs)
    elif model == "llava-next-video":
        from models import LLaVA
        return LLaVA.load_model(*args, **kwargs) 
    elif model == "mplug_owl3":
        from models import mPLUG_Owl3
        return mPLUG_Owl3.load_model(*args, **kwargs) 
    elif model == "videochat2":
        from models import VideoChat2
        return VideoChat2.load_model(*args, **kwargs) 
    elif "moviechat" in model:
        from models import MovieChat
        return MovieChat.load_model(*args, **kwargs) 
    elif model == "intern-vl25":
        from models import InternVL
        return InternVL.load_model(*args, **kwargs)
    elif model == "qwen-vl25":
        from models import QwenVL
        return QwenVL.load_model(*args, **kwargs) 
    elif model == "minicpm":
        from models import MiniCPM
        return MiniCPM.load_model(*args, **kwargs)
    elif model == "longvu":
        from models import LongVU
        return LongVU.load_model(*args, **kwargs)
    else:
        return {
            "random" : (None, None, None),
            # Proprietary models
            "gpt-4o" : lambda *x, **y : ("gpt-4o", None, None),
            "gpt-4.1" : lambda *x, **y : ("gpt-4.1", None, None),
            "gpt-5" : lambda *x, **y : ("gpt-5", None, None),
            "o1" : lambda *x, **y : ("o1", None, None),
            "o3" : lambda *x, **y : ("o3", None, None),
            "o4" : lambda *x, **y : ("o4", None, None),
            "o3-mini" : lambda *x, **y : ("o3-mini", None, None),
            "o4-mini" : lambda *x, **y : ("o4-mini", None, None),
            "gemini-1.5-pro" : lambda *x, **y : ("gemini-1.5-pro", None, None),
            "gemini-1.5-flash" : lambda *x, **y : ("gemini-1.5-flash", None, None),
            "gemini-2.5-pro" : lambda *x, **y : ("gemini-2.5-pro", None, None),
            "gemini-2.5-flash" : lambda *x, **y : ("gemini-2.5-flash", None, None)
        }[model](*args, **kwargs)
