#!/bin/sh

annotations_path="vidhal/annotations.json"
videos_path="vidhal/videos"
options_path="vidhal/options.json"
model="minicpm-8b"

python evaluate.py \
    --task "mcqa" \
    --annotations_path $annotations_path \
    --videos_path $videos_path \
    --predictions_path "outputs/inference/mcqa/${model}.json" \
    --save_path "outputs/evaluation/mcqa/${model}.json" \
    --options_path $options_path

python evaluate.py \
    --task "naive_ordering" \
    --annotations_path $annotations_path \
    --videos_path $videos_path \
    --predictions_path "outputs/inference/naive_ordering/${model}.json" \
    --save_path "outputs/evaluation/naive_ordering/${model}.json" \
    --options_path $options_path

python evaluate.py \
    --task "relative_ordering" \
    --annotations_path $annotations_path \
    --videos_path $videos_path \
    --predictions_path "outputs/inference/relative_ordering/${model}.json" \
    --save_path "outputs/evaluation/relative_ordering/${model}.json" \
    --options_path $options_path