import sys
import random
import subprocess
from itertools import combinations
from itertools import product

dataset = 'voxceleb'

resolution = 32
inner_steps = 4
inner_iter = 2

config = 'configs/main/maml_voxceleb.yaml'
log = f'logs/video_{resolution}/'

print_step = 200
eval_step = 1000
save_step = 50000
seed = 0

# print_step = 10
# eval_step = 10
# save_step = 10

params = dict(
    inner_step = ['4', '8', '16'],
    inner_iter = ['2', '3', '4'],
    incremental = [True, False],
)
params_ = params.values()
params_ = list(product(*params_))
params = []
for p in params_:
    inner_steps, inner_iter, incremental = p
    params += [p]
print('length of search params:', len(params))

cmds = []
for p in params:
    inner_steps, inner_iter, incremental = p

    exp_name1 = '_'.join([
        'instep:{}'.format(inner_steps),
        'initer:{}'.format(inner_iter),
    ])
    exp_name2 = '_'.join([
        'incremental:{}'.foramt(incremental),
    ])
    log_dir = log + exp_name1 + '/' + exp_name2

    base_cmd = ' '.join([
        "srun1-large -c 8 python main.py",
        '--configs {}'.format(config),
        '--fname {}'.format(log_dir),
    ])

    override_cmd = ' '.join([
        '--print_step {}'.format(print_step),
        '--eval_step {}'.format(eval_step),
        '--save_step {}'.format(save_step),
        '--inner_step {}'.formate(inner_steps),
        '--inner_iter {}'.format(inner_iter),
        '--incremental {}'.format(incremental),
        '--seed {}'.format(seed),
    ])

    cmd = ' '.join([
        base_cmd,
        override_cmd,
    ])

    cmds.append(cmd)

idx = int(sys.argv[1])
print(idx)

cmd = cmds[idx-1]
print(cmd)
subprocess.call(cmd.split())

# while True:
#     cmd = cmds[idx-1]
#     print(cmd)
#     try:
#         subprocess.call(cmd.split())
#     except KeyboardInterrupt:
#         break

# idx = int(sys.argv[1])
