import torch

def rope_pos_for_patch_midpoints(
    image_size: int,
    patch_size: int,
    scale_into_range: bool = 1000 # well suited for RoPE it seems
) -> torch.Tensor:
    """
    Compute the (x, y) coordinates of the midpoint of each patch in a quadratic image with quadratic patches.

    Args:
        image_size (int): Height and width of the original (quadratic) image.
        patch_size (int): Height and width of each (quadratic) patch.

    Returns:
        torch.Tensor: Tensor of shape (num_patches, 2) containing the (x, y) coordinates of each patch's midpoint.
    """
    num_patches_per_dim = image_size // patch_size
    indices = torch.arange(num_patches_per_dim) * patch_size + patch_size // 2
    y, x = torch.meshgrid(indices, indices, indexing='ij')
    positions = torch.stack([x, y], dim=-1)  # Shape: (num_patches_per_dim, num_patches_per_dim, 2)
    # positions = positions.reshape(-1, 2)
    if scale_into_range > 0:
        positions = positions / image_size * scale_into_range
        positions = positions / image_size * scale_into_range
    return positions
