import torch

def cum_mean_and_variance_torch(frame_list):
    
    # let mu_t, sigma_t be the cumulative mean and variances respectively
    # let d_mu_t = mu_t - mu_{t-1} and d_sigma_t respectively
    mus = []
    sigmas = []
    mu_norms = []
    sigma_norms = []
    
    d_mus = []
    d_sigmas = []
    avg_d_mu_norms = []
    avg_d_sigma_norms = []

    # following: https://chat.mistral.ai/chat/92b27f15-16ec-4552-b928-65e0c8aaa969
    mu_t = torch.zeros_like(frame_list[0])
    S_t = torch.zeros_like(frame_list[0])
    var_t = torch.zeros_like(frame_list[0])

    for i in range(len(frame_list)):
        x_t = frame_list[i]
        n = i + 1
        
        # compute mu_{t+1} denoted mu_tt
        mu_tt = mu_t + (x_t - mu_t) / n
        S_t = S_t + (x_t - mu_t) * (x_t - mu_tt)        
        var_tt = S_t / n

        mus.append(mu_tt)
        sigmas.append(var_tt)
        mu_norms.append(torch.linalg.norm(mu_tt, axis=-1))
        sigma_norms.append(torch.linalg.norm(var_tt, axis=-1))
        # diff
        diff_cum_mean = mu_tt - mu_t
        diff_cum_var = var_tt - var_t
        d_mus.append(diff_cum_mean)
        d_sigmas.append(diff_cum_var)
        avg_d_mu_norms.append(torch.linalg.norm(diff_cum_mean, axis=-1).mean(axis=-1))
        avg_d_sigma_norms.append(torch.linalg.norm(diff_cum_var, axis=-1).mean(axis=-1))
        
        mu_t = mu_tt
        var_t = var_tt
    
    avg_d_mu_norms = torch.stack(avg_d_mu_norms)
    avg_d_sigma_norms = torch.stack(avg_d_sigma_norms)
    
    return {
        'mus': mus,
        'sigmas': sigmas,
        'mu_norms': mu_norms,
        'sigma_norms': sigma_norms,
        'd_mus': d_mus,
        'd_sigmas': d_sigmas,
        'avg_d_mu_norms': avg_d_mu_norms,
        'avg_d_sigma_norms': avg_d_sigma_norms,
    }