

def compare_dicts(a, b, parent_key=''):
    result = []
    for key in b:
        if key not in a:
            result.append(f"{parent_key}{key}={b[key]}")
        else:
            if isinstance(b[key], dict) and isinstance(a[key], dict):
                result.extend(compare_dicts(a[key], b[key], f"{parent_key}{key}."))
            elif b[key] != a[key]:
                result.append(f"{parent_key}{key}={b[key]}")
    return result


def overrides_as_str(a, b):
    result_list_of_str = compare_dicts(a,b)
    result_list_of_str = sorted(result_list_of_str)
    return ", ".join(result_list_of_str)




if __name__ == '__main__':
    
    # Example usage:
    a = {
        'x': {
            'y': {
                'z': 1
            },
            'w': 2
        }
    }

    b = {
        'x': {
            'y': {
                'z': 3,
                'new_key': 4
            },
            'w': 2
        },
        'new_top_key': 5
    }

    differences = compare_dicts(a, b)
    print("\n".join(differences))