#!/bin/bash
set -e # Exit immediately if a command exits with a non-zero status.

GPU_LIST=(0 1)
NUM_GPUS=${#GPU_LIST[@]}

env_list=(
    "hopper-medium-v2"
    "halfcheetah-medium-v2"
    "walker2d-medium-v2"
    "hopper-medium-replay-v2"
    "halfcheetah-medium-replay-v2"
    "walker2d-medium-replay-v2"
    "hopper-medium-expert-v2"
    "halfcheetah-medium-expert-v2"
    "walker2d-medium-expert-v2"
)

task_id=0 # Initialize task counter

echo "Starting experiment launches..."
echo "Total jobs to launch: $(echo "5 * ${#env_list[@]} * 2" | bc)"
echo "Distributing across ${NUM_GPUS} GPUs: ${GPU_LIST[*]}"
echo "---"

for seed in 0 1 2 3 4; do
  for env in "${env_list[@]}"; do # Use quotes and @ for robustness with spaces (though not needed here)
    for exp_traj in 200 30; do

      GPU_DEVICE_INDEX=$((task_id % NUM_GPUS))
      GPU_DEVICE=${GPU_LIST[$GPU_DEVICE_INDEX]}

      echo "Launching Task ID: $task_id | Seed: $seed | Env: $env | ExpTraj: $exp_traj | GPU: $GPU_DEVICE"

      CUDA_VISIBLE_DEVICES=$GPU_DEVICE python train_offline_imitate.py \
        --env_name="$env" \
        --expert_trajectories="$exp_traj" \
        --actor_temp=0.04 \
        --temp=20 \
        --config=configs/mujoco_config.py \
        --seed="$seed" & # Run in background

      sleep 2 # Stagger job starts to avoid overwhelming system/GPUs
      task_id=$((task_id + 1)) # Increment for each job launched

    done # end exp_traj loop
  done # end env loop
done # end seed loop

echo "---"
echo "All jobs launched. Waiting for them to complete..."
wait # Wait for all background jobs to finish
echo "All jobs completed."