#!/bin/bash
set -e # Exit immediately if a command exits with a non-zero status.

GPU_LIST=(0 1)
NUM_GPUS=${#GPU_LIST[@]}

env_list=(
   "pen-human-v0"
   "door-human-v0"
   "hammer-human-v0"
   "kitchen-mixed-v0"
)

env_list_1=(
    "door-cloned-v0"
    "hammer-cloned-v0"
    "kitchen-partial-v0"
)

task_id=0 # Initialize task counter

echo "Starting experiment launches..."
# Calculate total jobs: 5 seeds * (4 envs + 1 pen-cloned + 3 envs_1) = 5 * 8 = 40
total_jobs_per_seed=$((${#env_list[@]} + 1 + ${#env_list_1[@]}))
total_jobs=$(echo "5 * $total_jobs_per_seed" | bc)
echo "Total jobs to launch: $total_jobs"
echo "Distributing across ${NUM_GPUS} GPUs: ${GPU_LIST[*]}"
echo "---"

for seed in 0 1 2 3 4; do
  echo "Processing Seed: $seed"

  # --- Batch 1 ---
  for env in "${env_list[@]}"; do
    GPU_DEVICE_INDEX=$((task_id % NUM_GPUS))
    GPU_DEVICE=${GPU_LIST[$GPU_DEVICE_INDEX]}
    echo "  Task ID: $task_id | Env: $env | ExpTraj: 30 | ActorTemp: 0.01 | Temp: 10 | GPU: $GPU_DEVICE"
    CUDA_VISIBLE_DEVICES=$GPU_DEVICE python train_offline_imitate.py \
      --env_name="$env" \
      --expert_trajectories=30 \
      --actor_temp=0.01 \
      --temp=10 \
      --config=configs/mujoco_config.py \
      --seed="$seed" &
    sleep 2
    task_id=$((task_id + 1))
  done

  # --- Special Case: pen-cloned-v0 ---
  GPU_DEVICE_INDEX=$((task_id % NUM_GPUS))
  GPU_DEVICE=${GPU_LIST[$GPU_DEVICE_INDEX]}
  echo "  Task ID: $task_id | Env: pen-cloned-v0 | ExpTraj: 30 | ActorTemp: 0.04 | Temp: 3 | GPU: $GPU_DEVICE"
  CUDA_VISIBLE_DEVICES=$GPU_DEVICE python train_offline_imitate.py \
    --env_name="pen-cloned-v0" \
    --expert_trajectories=30 \
    --actor_temp=0.04 \
    --temp=3 \
    --config=configs/mujoco_config.py \
    --seed="$seed" &
  sleep 2
  task_id=$((task_id + 1))

  # --- Batch 2 ---
  for env in "${env_list_1[@]}"; do
    GPU_DEVICE_INDEX=$((task_id % NUM_GPUS))
    GPU_DEVICE=${GPU_LIST[$GPU_DEVICE_INDEX]}
    echo "  Task ID: $task_id | Env: $env | ExpTraj: 30 | ActorTemp: 0.04 | Temp: 10 | GPU: $GPU_DEVICE"
    CUDA_VISIBLE_DEVICES=$GPU_DEVICE python train_offline_imitate.py \
      --env_name="$env" \
      --expert_trajectories=30 \
      --actor_temp=0.04 \
      --temp=10 \
      --config=configs/mujoco_config.py \
      --seed="$seed" &
    sleep 2
    task_id=$((task_id + 1))
  done
  echo "--- Finished launches for Seed: $seed ---"

done # end seed loop

echo "---"
echo "All jobs launched. Waiting for them to complete..."
wait # Wait for all background jobs to finish
echo "All jobs completed."