# Instructions to replicate our experiments

## 1. Setup a python environment
Create a new python 3 environment with the following packages installed:
- numpy (https://numpy.org/)
- scikit-learn (https://scikit-learn.org/stable/)
- matplotlib (https://matplotlib.org/)
- pandas (https://pandas.pydata.org/)

This can be accomplished using the conda package manager (https://docs.conda.io/en/latest/) with the following: 
```bash
conda create -n neurips_env
conda activate neurips_env
conda config --env --add channels conda-forge
conda install numpy scikit-learn matplotlib pandas tqdm -y
````

## Running the experiments
To run our experiments, execute the following under the conda environment created above. The results plots will be placed in the results folder. In the body of our paper we only show the row corresponding to a batch size of 1024.
```bash
python neurips_code.py run
python neurips_code.py plot
```

<!-- show the picture in the results folder -->

Full results:
![Full experimental results](results/final/results.png "Full experimental results")


Results used in the paper:

![Paper results](results/final/results_1024.png "Results used in the paper")

