from google.cloud import storage
from google.cloud import bigquery
from .config import VERTEX_BUCKET, GCP_PROJECT_ID

storage_client = storage.Client(project=GCP_PROJECT_ID)
bucket = storage_client.bucket(f"{VERTEX_BUCKET}")
bigquery_client = bigquery.Client(project=GCP_PROJECT_ID)

def reload_bucket(new_bucket_name):
    global bucket
    global VERTEX_BUCKET
    VERTEX_BUCKET = new_bucket_name
    bucket = storage_client.bucket(f"{VERTEX_BUCKET}")