import os
import yaml
import subprocess

def update_config_yaml(config_path, samples_path, corpus_path):
    with open(config_path, 'r', encoding='utf-8') as f:
        config = yaml.safe_load(f)
    
    config['samples']['paths'] = [samples_path]
    config['corpus']['paths'] = [corpus_path]

    with open(config_path, 'w', encoding='utf-8') as f:
        yaml.dump(config, f, default_flow_style=False, allow_unicode=True)

def run_synthtiger(output_dir, count, config_path):
    os.makedirs(output_dir, exist_ok=True)
    command = f"synthtiger -o {output_dir} -c {count} -w 1 -s 610 -v examples/viper_multiline/template.py Multiline {config_path}"
    result = subprocess.run(command, shell=True, capture_output=True, text=True)
    if result.returncode != 0:
        print(f"SynthTiger failed: {output_dir}\n{result.stderr}")
    else:
        print(f"Completed: {output_dir}")

def main():
    embedding_methods = ['easyocr', 'paddleocr', 'viper']
    p_values = ['05', '10']
    image_count = 1996
    config_path = 'examples/viper_multiline/config.yaml'

    all_done = []

    for embedding_method in embedding_methods:
        for p in p_values:
            base_dir = f"glyphdecode_test_data/{embedding_method}"
            samples_path = os.path.join(base_dir, f"output_multiline_{p}", "samples.json")
            corpus_path = os.path.join(base_dir, f"output_multiline_{p}", "transformed_texts.txt")
            output_dir = os.path.join(base_dir, f"images_multiline_{p}")

            update_config_yaml(config_path, samples_path, corpus_path)
            run_synthtiger(output_dir, image_count, config_path)
            all_done.append(f"{embedding_method}-{p}")

    print("\nMultiline image generation complete.")
    print(f"Generated datasets: {all_done}")

if __name__ == "__main__":
    main()