/* LUT-GEMM
 * Copyright (c) 2024-present NAVER Cloud Corp. All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma ones

#ifndef KERNELS_H
#define KERNELS_H

#include "nQWeight_fp16.h"

namespace codeGEMM{

void matmul(void* output, nQWeight_fp16 &nqW, void* input, int n);
void matmul(void* output, void* input, nQWeight_fp16 &nqW, int m);
void matmul_aqlm(void* output, void* input, nQWeight_fp16 &nqW, int m);
void matmul_quip_sharp(void* output, void* input, void* qidxs,
    void* codebook, int m, int n, int k);
template<int M, int K>
void matmul_qtip(void* output, void* input, void* d_compressed, void* codebook, 
    int n);
void dequant_aqlm(void* output, nQWeight_fp16 &nqW);
}

#endif

