# MLES Experiment Code and Results about DRL

This directory contains all the relevant code, results, and environments for the MLES (Multimodal LLM-assisted Evolutionary Search) experiment, focusing on Deep Reinforcement Learning (DRL) models.

## Files

- **Lunarlander_rl_test.py**: This script can be used to test the DQN and PPO models generated in our 5 experimental runs on the Lunar Lander environment.
- **Racingcar_rl_test.py**: This script is designed to test the DQN and PPO models generated in our 5 experimental runs on the Car Racing environment.
- **environment.yaml**: Provides a quick way to set up the Python environment with all necessary dependencies for running the experiments.

## Installation

You can quickly install the required Python environment by using the provided `environment.yml` file. Run the following command to create the environment:

```bash
conda env create -f environment.yml
```

Once the environment is set up, activate it:
```bash
conda activate rl
```
### Results
The results from the 5 experimental runs are saved in the respective output directories specified in the code. You can analyze the performance of the models based on the metrics provided in the scripts.

