import gymnasium as gym


class LunarLanderEnvironment:
    def __init__(self, render_mode=None):
        self.env = gym.make("LunarLander-v3", render_mode=render_mode)
        self.state_size = self.env.observation_space.shape[0]
        self.action_size = self.env.action_space.n

    def reset(self, seed=None):
        return self.env.reset(seed=seed)

    def step(self, action):
        return self.env.step(action)

    def close(self):
        self.env.close()

    def render(self):
        return self.env.render()

    def get_state_action_sizes(self):
        return self.state_size, self.action_size