import os
import json
from datetime import datetime

def create_results_dir(base_dir="results"):
    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    save_dir = os.path.join(base_dir, f"dqn_lunarlander_{timestamp}")
    os.makedirs(save_dir, exist_ok=True)
    return save_dir

def save_training_metadata(save_dir, config):
    with open(os.path.join(save_dir, 'config.json'), 'w') as f:
        json.dump(config, f, indent=2)