from scripting import *
import random
import os

random.seed(42)
ce = CE()

folder = 'synthetic_skeleton'

import sys
sys.path.append(ce.toFSPath('scripts'))
import helpers

start_axis=(-1800, -1800)
stop_axis=(1800, 1800)
step = 180
adjust_list = ['la', 'ca', 'li']
light_angle=90
camera_angle=90
light_intensity=0.8
dynamic_range={'ca': 10, 'la': 15, 'li': 0.3}
height='320'
camfile = ce.toFSPath("data/camera.fbx")
angle = helpers.dynamic_attributes(adjust_list, camera_angle, light_angle, light_intensity, dynamic_range, "RGB")

counter = 0
tag = 'roads'
for i in range(start_axis[0], stop_axis[0], step):
    for j in range(start_axis[1], stop_axis[1], step):
        view = helpers.importFbxCamera(camfile, (i, j), angle, height)

        helpers.exportImages(os.path.join(ce.toFSPath('images'), folder), view, Tag=tag + '_' + str(counter))
        counter = counter + 1

