import metrics_delin as md
import numpy as np
import timeout_decorator


def get_all_metrics(G_gt, G_pred, h, w):
    results = []

    # --------------------------------------------------
    try:

        @timeout_decorator.timeout(2)
        def fun(G_gt, G_pred):
            return md.opt_j(G_gt, G_pred, th_existing=1, th_snap=25, alpha=100)

        (
            f1,
            precision,
            recall,
            tp,
            pp,
            ap,
            matches_g,
            matches_hg,
            g_gt_snap,
            g_pred_snap,
        ) = fun(G_gt, G_pred)
    except:
        precision, recall, f1 = 0, 0, 0

    results.append(
        "OPT-J:          precision={:0.3f} recall={:0.3f} f1={:0.3f}\n".format(
            precision, recall, f1
        )
    )

    # --------------------------------------------------
    try:

        @timeout_decorator.timeout(2)
        def fun(G_gt, G_pred):
            scale = 1 / 4
            segments = np.array(
                [[G_gt.nodes[s]["pos"], G_gt.nodes[t]["pos"]] for s, t in G_gt.edges()]
            )
            gt_s = md.render_segments(
                segments * scale,
                filename=None,
                height=h * scale,
                width=w * scale,
                thickness=1,
            )

            segments = np.array(
                [
                    [G_pred.nodes[s]["pos"], G_pred.nodes[t]["pos"]]
                    for s, t in G_pred.edges()
                ]
            )
            pred_s = md.render_segments(
                segments * scale,
                filename=None,
                height=h * scale,
                width=w * scale,
                thickness=1,
            )

            return md.corr_comp_qual(gt_s, pred_s, slack=8 * scale)

        corr, comp, qual, TP_g, TP_p, FN, FP = fun(G_gt, G_pred)

    except:
        corr, comp, qual = 0, 0, 0

    results.append(
        "Corr-Comp-Qual: corr={:0.3f} comp={:0.3f} qual={:0.3f}\n".format(
            corr, comp, qual
        )
    )

    # --------------------------------------------------
    try:

        @timeout_decorator.timeout(2)
        def fun(G_gt, G_pred):
            return md.toolong_tooshort(
                G_gt, G_pred, n_paths=50, max_node_dist=25  # to speed up this script
            )

        correct, too_long, too_short, infeasible = fun(G_gt, G_pred)
    except:
        correct, too_long, too_short, infeasible = 0, 0, 0, 0
    results.append(
        "2Long-2Short:   correct={:0.3f} 2l+2s={:0.3f} inf={:0.3f}\n".format(
            correct, too_long + too_short, infeasible
        )
    )

    # --------------------------------------------------
    try:

        @timeout_decorator.timeout(2)
        def fun(G_gt, G_pred):
            return md.opt_p(G_gt, G_pred)

        (
            n_conn_precis,
            n_conn_recall,
            n_inter_precis,
            n_inter_recall,
            con_prob_precis,
            con_prob_recall,
            con_prob_f1,
        ) = fun(G_gt, G_pred)
    except:
        con_prob_precis, con_prob_recall, con_prob_f1 = 0, 0, 0
    results.append(
        "OPT-P:          con_prob_precis={:0.3f} con_prob_recall={:0.3f} con_prob_f1={:0.3f}\n".format(
            con_prob_precis, con_prob_recall, con_prob_f1
        )
    )

    # --------------------------------------------------
    try:

        @timeout_decorator.timeout(2)
        def fun(G_gt, G_pred):
            return md.holes_marbles(
                G_gt,
                G_pred,
                spacing=10,
                dist_limit=300,
                dist_matching=25,
                N=50,  # to speed up this script
                verbose=False,
            )

        (
            f1,
            spurious,
            missings,
            n_preds_sum,
            n_gts_sum,
            n_spurious_marbless_sum,
            n_empty_holess_sum,
        ) = fun(G_gt, G_pred)
    except:
        spurious, missings, f1 = 0, 0, 0
    results.append(
        "Hole-Marbles:   spurious={:0.3f} missings={:0.3f} f1={:0.3f}\n".format(
            spurious, missings, f1
        )
    )

    # --------------------------------------------------
    try:

        @timeout_decorator.timeout(2)
        def fun(G_gt, G_pred):
            return md.opt_g(
                G_gt,
                G_pred,
                spacing=10,
                dist_limit=300,
                dist_matching=25,
                N=50,  # to speed up this script
                verbose=False,
            )

        (
            f1,
            spurious,
            missings,
            n_preds_sum,
            n_gts_sum,
            n_spurious_marbless_sum,
            n_empty_holess_sum,
        ) = fun(G_gt, G_pred)
    except:
        spurious, missings, f1 = 0, 0, 0
    results.append(
        "OPT-G:          spurious={:0.3f} missings={:0.3f} f1={:0.3f}\n".format(
            spurious, missings, f1
        )
    )

    return results