## Create Synthetic Dataset of Occluded Roads with their pixel-level accurate labels

We use rules and textures modified from [Synthinel](https://github.com/timqqt/Synthinel). Wr briefly describe steps to reproduce the dataset.


1. Create a road layout by growing streets in CityEngine with the desired parameters.
2. Select all shapes and apply a specified texture. We use the rules from Synthinel. Generate all models.
3. Add plants in the sidewals by running the script ``apply_trees.py`` with mode RGB.
4. Create RGB data by running the script ``create_data.py``. You can modify camera height, angle and step size when scanning your city.
5. Next we create the road masks. Set the visibility of all blocks to False.
6. Apply a black color map to all roads.
```
from scripting import *
import math

objs = ce.isShape
all_shapes = ce.getObjectsFrom(ce.scene, objs)
steets = list(filter(lambda x: ce.getAttribute(x, "shapeType") in ["Joint", "Roundabout", "Street", "Junction", "Crossing"], all_shapes))

ce.setRuleFile(all_shapes, "black.cga")
ce.setStartRule(all_shapes, "Col")
```
7. Possibly remove wireframes and centerlines. Then run ``create_data.py`` to create the road masks.
8. Next we create the plants along the sidewalk masks.
```
ce.setRuleFile(steets, "white.cga")
ce.setStartRule(steets, "Col")
```
9. Remove wireframes, centerlines and shadows.
10. Add plant masks by running ``apply_trees`` with mode segmentation.
11. Run ``create_data.py`` to create the plant masks.
12. Provided masks are in RGB format. Possibly threshold images to create the respective grayscale ones.