from scripting import *
import math
import random

# get a CityEngine instance
ce = CE()

random.seed(42)

mode = 'segmentation'

if mode == 'RGB':
    rule_file_path = "Plants/trees.cga"
elif mode == 'segmentation':
    rule_file_path = "Plants/trees_masks.cga"
    
objs = ce.isShape
all_shapes = ce.getObjectsFrom(ce.scene, objs)
sidewalks = list(filter(lambda x: ce.getAttribute(x, "shapeType") == "Sidewalk", all_shapes))
 
ce.setRuleFile(sidewalks, rule_file_path)
ce.setStartRule(sidewalks, "Generate")
ce.generateModels(all_shapes)
ce.waitForUIIdle()   