# Mastering Spatial Graph Prediction of Road Networks

This is an early code release.

## Overview
<p float="left">
  <img src='/assets/base_model.png' width="49%">
  <img src='/assets/muzero_model.png' width="49%">
</p>

## Requirements
```
git submodule init (or git clone https://github.com/lcit/metrics_delin for this anonymized version)
pip install -r requirements.txt
```

## Run Experiments

Examples of the synthetic dataset are given in the folder ``data`` along with their respective segmentation prediction. To run our code simply execute:

```
CUDA_VISIBLE_DEVICES=0,1,2,3 python muzero.py --gpus_actors 0 --output_folder_name cityengine_ --game_name cityengine --gpus_training_worker 2
```

This will request a total of 4 GPUS, 2 for the learner workers, 1 for the reanalyze worker and 1 for the evaluator worker. You can specify number of GPU workers and other checkpoint parameters as indicated by the arguments ``python muzero.py --help``. The MuZero training and search parameters are configured in the game config files, e.g. [cityengine_config](games/cityengine.py) for the cityengine dataset. In reality only 1 GPU is essential, for the learner worker.

The complete synthetic dataset will be publicly released.

## Acknowledgements

Parts of this repository were inspired by:
* [road_connectivity](https://github.com/anilbatra2185/road_connectivity)
* [PolyGen](https://github.com/deepmind/deepmind-research/tree/master/polygen)
* [metrics_delin](https://github.com/lcit/metrics_delin)
* [muzero-general](https://github.com/werner-duvaud/muzero-general)
* [APLS](https://github.com/CosmiQ/apls)
