#!/bin/bash
#SBATCH -J lisa                 # Job name
#SBATCH -N1 --gres=gpu:H100:1
#SBATCH -t 480                                    # Duration of the job (Ex: 15 mins)
#SBATCH --mem-per-cpu=5G
#SBATCH -o lisa_poison_ratio-%j.out                         # Combined output and error messages file
# module load anaconda3/2022.05.0.1
# module load cuda/11.7.0-7sdye3
# module load anaconda3/2023.03
# module load cuda/11.8.0

# source activate hts

guide_data_num=1000
RHO=0.01 
# density=$2
poison_ratio=${1:-0.1}
sample_num=1000
align_step=100   
finetune_step=900 
bad_sample_num=1000
model_path=meta-llama/Meta-Llama-3-8B
path_after_slash=$(basename "$model_path") 
echo "The value of RHO is: $RHO"
# echo "The value of density is: $density"
echo "The value of poison_ratio is: $poison_ratio"
echo "The value of sample number is: $sample_num"
echo "The align step is: $align_step"
echo "The finetune step is: $finetune_step"
echo "The model is: $model_path"
echo "Guide data num is: $guide_data_num"
# cd  ../../                            # Change to working directory

CUDA_VISIBLE_DEVICES=3 python train.py \
	--model_name_or_path ${model_path}\
	--lora_folder outputs/ckpt/Meta-Llama-3-8B_sft_10000  \
	--data_path PKU-Alignment/BeaverTails_dangerous \
	--bf16 True \
	--output_dir outputs/ckpt/${path_after_slash}_lisa_f_${RHO}_${poison_ratio}_${sample_num}_${align_step}_${finetune_step}_${guide_data_num} \
	--num_train_epochs 20 \
	--per_device_train_batch_size 10 \
	--per_device_eval_batch_size 10 \
	--gradient_accumulation_steps 1 \
	--save_strategy "steps" \
	--save_steps 100000 \
	--save_total_limit 0 \
	--learning_rate 1e-5 \
	--weight_decay 0.1 \
	--warmup_ratio 0.1 \
	--lr_scheduler_type "constant" \
	--logging_steps 10 \
	--tf32 True \
	--eval_steps 5000 \
	--cache_dir cache \
	--optimizer lisa \
	--evaluation_strategy  "steps" \
	--sample_num $sample_num \
	--poison_ratio ${poison_ratio} \
	--label_smoothing_factor  0 \
	--benign_dataset data/gsm8k.json \
	--rho ${RHO} \
	--alignment_step ${align_step} \
	--finetune_step ${finetune_step} \
	--guide_data_num ${guide_data_num} \
	--random_seed 42


# cd poison/evaluation  


# CUDA_VISIBLE_DEVICES=3 python pred.py \
# 	--lora_folder ../../ckpt/${path_after_slash}_lisa_${RHO} \
# 	--model_folder ${model_path} \
# 	--output_path ../../data/pred/lisa_${RHO}

# CUDA_VISIBLE_DEVICES=3 python eval_sentiment.py \
# 	--input_path ../../data/pred/lisa_${RHO}



CUDA_VISIBLE_DEVICES=3 python poison/evaluation/pred.py \
	--lora_folder outputs/ckpt/Meta-Llama-3-8B_sft_10000  \
	--lora_folder2 outputs/ckpt/${path_after_slash}_lisa_f_${RHO}_${poison_ratio}_${sample_num}_${align_step}_${finetune_step}_${guide_data_num} \
	--model_folder ${model_path} \
	--output_path outputs/ckpt/${path_after_slash}_lisa_f_${RHO}_${poison_ratio}_${sample_num}_${align_step}_${finetune_step}_${guide_data_num}/pred.json


CUDA_VISIBLE_DEVICES=3 python poison/evaluation/eval_sentiment.py \
	--input_path outputs/ckpt/${path_after_slash}_lisa_f_${RHO}_${poison_ratio}_${sample_num}_${align_step}_${finetune_step}_${guide_data_num}/pred.json



# cd ../../sst2

CUDA_VISIBLE_DEVICES=3 python gsm8k/pred_eval.py   \
	--lora_folder outputs/ckpt/Meta-Llama-3-8B_sft_10000  \
	--lora_folder2 outputs/ckpt/${path_after_slash}_lisa_f_${RHO}_${poison_ratio}_${sample_num}_${align_step}_${finetune_step}_${guide_data_num} \
	--model_folder ${model_path} \
	--output_path outputs/ckpt/${path_after_slash}_lisa_f_${RHO}_${poison_ratio}_${sample_num}_${align_step}_${finetune_step}_${guide_data_num}/gsm8k_pred.json