# GRACE: A Stable Backdoor Defense for Federated Learning with Combinatorial Data Class Representations

## Get started
## Requirements
Some pip packages are required by this library, and may need to be installed. For more details, see requirements.txt. We recommend running pip install --requirement "requirements.txt"

### Data  preparation
Dataset FashionMnist and CIFAR10/100 will be automatically downloaded with TorchVision.

### Command to run
The following code run lockdown in its default setting
```
python federated.py  --method Grace 
```

### Files organization
* The main simulation program is in `federated.py`, where we initialize the benign and poison dataset, call clients to do local training, call aggregator to do aggregation, do consensus fusion before testing, etc.


* The Lockdown's client local training logistic is in `agent_sparse.py`. 

* The vanilla FedAvg' client local training logistic is in `agent.py`. 

* The aggregation logistic is in `aggregation.py`, where we implement multiple defense baselines. 

* The data poisoning, data preparation and data distribution logistic is in `utils.py`.


### Logging and checkpoint
The logging files will be contained in `save/logs`. Benign accuracy, ASR, and Backdoor accuracy will be tested in every round.
For Grace, the three metrics correspond to the following logging format:
```
| Clean Val_Loss/Val_Acc: (Benign loss) / (Benign accuracy) |
| Clean Attack Success Ratio: (ASR loss)/ (ASR) |
| Clean Poison Loss/Clean Poison accuracy:: (Backdoor Loss)/ (Backdoor Acc)|
```
Model checkpoints will be saved every 50 rounds in the directory `save/checkpoint`.

## Acknowledgment
The codebase is modified and adapted from 
[Lockdown](https://github.com/git-disl/Lockdown)
[LeadFL](https://github.com/CarlosChu-c/LeadFL)
[FLAME](https://github.com/zhmzm/FLAME)
[FedCR](https://github.com/haozzh/FedCR)
[FedCPA](https://github.com/siquanhuang/Multi-metrics)
[DBA](https://github.com/AI-secure/DBA)
[Data-partition](https://github.com/Xtra-Computing/NIID-Bench)


## License
If our paper is accepted, we will release the code
