---
name: New Issue
about: Read before creating a new issue
title: ''
labels: ''
assignees: ''

---

# **Read before creating a new issue**

- Users who want to use SpikingJelly should first be familiar with the usage of PyTorch. 
- If you do not know much about PyTorch, we recommend that the user can learn the [basic tutorials of PyTorch](https://pytorch.org/tutorials/).
- Do not ask for help with the basic conception of PyTorch/Machine Learning but not related to SpikingJelly. For these questions, please refer to Google or [PyTorch Forums](https://discuss.pytorch.org/).

**For faster response**

You can @ the corresponding developers for your issue. Here is the division:

| Features                         | Developers                                                   |
| -------------------------------- | ------------------------------------------------------------ |
| Neurons and Surrogate Functions  | [fangwei123456](https://github.com/fangwei123456)<br />[Yanqi-Chen](https://github.com/Yanqi-Chen) |
| CUDA Acceleration                | [fangwei123456](https://github.com/fangwei123456)<br />[Yanqi-Chen](https://github.com/Yanqi-Chen) |
| Reinforcement Learning           | [lucifer2859](https://github.com/lucifer2859)                |
| ANN to SNN Conversion            | [DingJianhao](https://github.com/DingJianhao)<br />[Lyu6PosHao](https://github.com/Lyu6PosHao) |
| Biological Learning (e.g., STDP) | [AllenYolk](https://github.com/AllenYolk)                    |
| Others                           | [Grasshlw](https://github.com/Grasshlw)<br />[lucifer2859](https://github.com/lucifer2859)<br />[AllenYolk](https://github.com/AllenYolk)<br />[Lyu6PosHao](https://github.com/Lyu6PosHao)<br />[DingJianhao](https://github.com/DingJianhao)<br />[Yanqi-Chen](https://github.com/Yanqi-Chen)<br />[fangwei123456](https://github.com/fangwei123456) |

We are glad to add new developers who are volunteering to help solve issues to the above table.

**Issue type**

- [ ] Bug Report
- [ ] Feature Request
- [ ] Help wanted
- [x] Other

**SpikingJelly version**

`0.0.0.0.2`

**Description**

...

**Minimal code to reproduce the error/bug**

```python
import spikingjelly
# ...
```
