## Publications using SpikingJelly

| Papers                                                       | Codes                                                        | Publisher                                                    |
| ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| [Incorporating Learnable Membrane Time Constant to Enhance Learning of Spiking Neural Networks](https://arxiv.org/abs/2007.05785) | https://github.com/fangwei123456/Parametric-Leaky-Integrate-and-Fire-Spiking-Neuron | ICCV 2021                                                    |
| [Pruning of Deep Spiking Neural Networks through Gradient Rewiring](https://arxiv.org/abs/2105.04916) | https://github.com/Yanqi-Chen/Gradient-Rewiring              | IJCAI 2021                                                   |
| [Optimal ANN-SNN Conversion for Fast and Accurate Inference in Deep Spiking Neural Networks](https://arxiv.org/abs/2105.11654) | https://github.com/DingJianhao/OptSNNConvertion-RNL-RIL      | IJCAI 2021                                                   |
| [Deep Residual Learning in Spiking Neural Networks](https://arxiv.org/abs/2102.04159) | https://github.com/fangwei123456/Spike-Element-Wise-ResNet   | NeurIPS 2021                                                 |
| [Spiking Neural Networks Trained via Proxy](https://arxiv.org/abs/2109.13208) | https://github.com/SRKH/ProxyLearning                        | IEEE Access                                                  |
| [StereoSpike: Depth Learning with a Spiking Neural Network](https://arxiv.org/abs/2109.13751) | https://github.com/urancon/StereoSpike                       |                                                              |
| [An Odor Recognition Algorithm of Electronic Noses Based on Convolutional Spiking Neural Network for Spoiled Food Identification](https://iopscience.iop.org/article/10.1149/1945-7111/ac1699/meta) |                                                              | Journal of The Electrochemical Society                       |
| [Cascade Spiking Neuron Network For Event-based Image Classification In Noisy Environment](https://www.techrxiv.org/articles/preprint/Cascade_Spiking_Neuron_Network_For_Event-based_Image_Classification_In_Noisy_Environment/16571043) |                                                              |                                                              |
| [Keys to Accurate Feature Extraction Using Residual Spiking Neural Networks](https://iopscience.iop.org/article/10.1088/2634-4386/ac8bef/meta) | https://github.com/VicenteAlex/Spiking_ResNet                | Neuromorphic Computing and Engineering                       |
| [Human-Level Control through Directly-Trained Deep Spiking Q-Networks](https://arxiv.org/abs/2201.07211) | https://github.com/AptX395/Deep-Spiking-Q-Networks           |                                                              |
| [Deep Reinforcement Learning with Spiking Q-learning](https://arxiv.org/abs/2201.09754) |                                                              |                                                              |
| [Event-based Video Reconstruction via Potential-assisted Spiking Neural Network](https://arxiv.org/abs/2201.10943) | https://github.com/LinZhu111/EVSNN                           | CVPR 2022                                                    |
| [Optimal ANN-SNN Conversion for High-accuracy and Ultra-low-latency Spiking Neural Networks](https://openreview.net/forum?id=7B3IJMM1k_M) | https://github.com/putshua/SNN-conversion-QCFS               | ICLR 2022                                                    |
| [Optimized Potential Initialization for Low-latency Spiking Neural Networks](https://arxiv.org/abs/2202.01440) |                                                              | AAAI 2022                                                    |
| [AutoSNN: Towards Energy-Efficient Spiking Neural Networks](https://arxiv.org/abs/2201.12738) |                                                              | ICML 2022                                                    |
| [Neural Architecture Search for Spiking Neural Networks](https://arxiv.org/abs/2201.10355) | https://github.com/Intelligent-Computing-Lab-Yale/Neural-Architecture-Search-for-Spiking-Neural-Networks | ECCV 2022                                                    |
| [FEAS: A Faster Event-driven Accelerator Supporting Inhibitory Spiking Neural Network](https://ieeexplore.ieee.org/document/9720483/) |                                                              | International Symposium on Parallel Architectures, Algorithms and Programming (PAAP) 2021 |
| [Neuromorphic Data Augmentation for Training Spiking Neural Networks](https://arxiv.org/abs/2203.06145) | https://github.com/Intelligent-Computing-Lab-Yale/NDA_SNN    | ECCV 2022                                                    |
| [SIT: A Bionic and Non-Linear Neuron for Spiking Neural Network](https://arxiv.org/abs/2203.16117) |                                                              |                                                              |
| [Building and training a deep spiking neural network for ECG classification](https://www.sciencedirect.com/science/article/pii/S1746809422002713) |                                                              | Biomedical Signal Processing and Control                     |
| [DynSNN: A Dynamic Approach to Reduce Redundancy in Spiking Neural Networks](https://ieeexplore.ieee.org/abstract/document/9746566) |                                                              | ICASSP 2022                                                  |
| [Object Detection with Spiking Neural Networks on Automotive Event Data](https://arxiv.org/abs/2205.04339) |                                                              | IJCNN 2022                                                   |
| [State Transition of Dendritic Spines Improves Learning of Sparse Spiking Neural Networks](https://proceedings.mlr.press/v162/chen22ac.html) | https://github.com/Yanqi-Chen/STDS                           | ICML 2022                                                    |
| [Training High-Performance Low-Latency Spiking Neural Networks by Differentiation on Spike Representation](https://arxiv.org/abs/2205.00459) | https://github.com/qymeng94/DSR                              | CVPR 2022                                                    |
| [Relaxation LIF: A gradient-based spiking neuron for direct training deep spiking neural networks](https://www.sciencedirect.com/science/article/pii/S092523122200755X) |                                                              | Neurocomputing                                               |
| [SNN2ANN: A Fast and Memory-Efficient Training Framework for Spiking Neural Networks](https://arxiv.org/abs/2206.09449) | https://github.com/TJXTT/SNN2ANN                             |                                                              |
| [Spiking Neural Networks for Frame-based and Event-based Single Object Localization](https://arxiv.org/abs/2206.06506) |                                                              |                                                              |
| [TCJA-SNN: Temporal-Channel Joint Attention for Spiking Neural Networks](https://arxiv.org/abs/2206.10177) | https://github.com/ridgerchu/TCJA                            |                                                              |
| [Exploring Lottery Ticket Hypothesis in Spiking Neural Networks](https://arxiv.org/abs/2207.01382) | https://github.com/Intelligent-Computing-Lab-Yale/Exploring-Lottery-Ticket-Hypothesis-in-SNNs | ECCV 2022                                                    |
| [Spiking Graph Convolutional Networks](https://arxiv.org/abs/2205.02767) | https://github.com/ZulunZhu/SpikingGCN                       | IJCAI 2022                                                   |
| [Spiking VGG7: Deep Convolutional Spiking Neural Network with Direct Training for Object Recognition](https://www.mdpi.com/2079-9292/11/13/2097) |                                                              | Electronics                                                  |
| [Spiking Neural Network Based on Layer-Wise Compensation for Event-Stream Image Classification](https://link.springer.com/chapter/10.1007/978-981-19-3927-3_72) |                                                              | International Technical Conference on Advances in Computing, Control and Industrial Engineering (CCIE 2021) |
| [A calibratable sensory neuron based on epitaxial VO2 for spike-based neuromorphic multisensory system](https://www.nature.com/articles/s41467-022-31747-w) | https://github.com/billyuanpku96/SNN-for-sensory-neuron      | Nature Communications                                        |
| [A model of TaOx threshold switching memristor for neuromorphic computing](https://aip.scitation.org/doi/full/10.1063/5.0096643) |                                                              | Journal of Applied Physics                                   |
| [Label Distribution Learning via Implicit Distribution Representation](https://arxiv.org/abs/2209.13824) |                                                              |                                                              |
| [Spiking SiamFC++: Deep Spiking Neural Network for Object Tracking](https://arxiv.org/abs/2209.12010) |                                                              |                                                              |
| [Spikformer: When Spiking Neural Network Meets Transformer](https://openreview.net/forum?id=frE4fUwz_h) | https://github.com/ZK-Zhou/spikformer                        | ICLR 2023                                                    |
| [SNN-SC: A Spiking Semantic Communication Framework for Classification](https://arxiv.org/abs/2210.06836) |                                                              |                                                              |
| [STSC-SNN: Spatio-Temporal Synaptic Connection with Temporal Convolution and Attention for Spiking Neural Networks](https://arxiv.org/abs/2210.05241) |                                                              |                                                              |
| [Online Training Through Time for Spiking Neural Networks](https://arxiv.org/abs/2210.04195) | https://github.com/pkuxmq/OTTT-SNN                           | NeurIPS 2022                                                 |
| [Training Spiking Neural Networks with Event-driven Backpropagation](https://openreview.net/forum?id=nC8VC8gVGPo) | https://github.com/zhuyaoyu/SNN-event-driven-learning        | NeurIPS 2022                                                 |
| [GLIF: A Unified Gated Leaky Integrate-and-Fire Neuron for Spiking Neural Networks](https://openreview.net/forum?id=UmFSx2c4ubT) | https://github.com/Ikarosy/Gated-LIF                         | NeurIPS 2022                                                 |
| [Temporal Effective Batch Normalization in Spiking Neural Networks](https://openreview.net/forum?id=fLIgyyQiJqz) |                                                              | NeurIPS 2022                                                 |
| [Attention Spiking Neural Networks](https://ieeexplore.ieee.org/document/10032591) | https://github.com/fangwei123456/spikingjelly/pull/329       | IEEE Transactions on Pattern Analysis and Machine Intelligence |
| [Training Full Spike Neural Networks via Auxiliary Accumulation Pathway](https://arxiv.org/abs/2301.11929) |                                                              |                                                              |
| [Bridging the Gap between ANNs and SNNs by Calibrating Offset Spikes](https://openreview.net/forum?id=PFbzoWZyZRX) | https://github.com/hzc1208/ANN2SNN_COS                       | ICLR 2023                                                    |
| [A Unified Framework of Soft Threshold Pruning](https://openreview.net/forum?id=cCFqcrq0d8) |                                                              | ICLR 2023                                                    |
| [Reducing ANN-SNN Conversion Error through Residual Membrane Potential](https://arxiv.org/abs/2302.02091) | https://github.com/hzc1208/ANN2SNN_SRP                       | AAAI 2023                                                    |
| [MSS-DepthNet: Depth Prediction with Multi-Step Spiking Neural Network](https://arxiv.org/abs/2211.12156) |                                                              |                                                              |
| [An Analytical Estimation of Spiking Neural Networks Energy Efficiency](https://arxiv.org/abs/2210.13107) |                                                              | ICONIP 2022                                                  |
| [Spikeformer: A Novel Architecture for Training High-Performance Low-Latency Spiking Neural Network](https://arxiv.org/abs/2211.10686) |                                                              |                                                              |
| [A Low Latency Adaptive Coding Spiking Framework for Deep Reinforcement Learning](https://arxiv.org/abs/2211.11760) |                                                              |                                                              |
| [Skin Cancer Classification Using Deep Spiking Neural Network](https://link.springer.com/article/10.1007/s10278-023-00776-2) |                                                              | Journal of Digital Imaging                                   |
| [Entrenamiento supervisado de redes neuronales de impulsos](https://ruc.udc.es/dspace/handle/2183/31382) |                                                              | XLIII Jornadas de Automática                                 |
| [Spiking Neuron Network Based on VTEAM Memristor and MOSFET-LIF Neuron](https://link.springer.com/chapter/10.1007/978-3-031-14903-0_5) |                                                              | International Federation for Information Processing 2022     |
| [Spiking Emotions: Dynamic Vision Emotion Recognition Using Spiking Neural Networks](https://ceur-ws.org/Vol-3331/paper08.pdf) |                                                              | International Conference on Algorithms, High Performance Computing and Artificial Intelligence 2022 |
| [Bio-inspired Active Learning method in spiking neural network](https://www.sciencedirect.com/science/article/pii/S0950705122012898) |                                                              | Knowledge-Based Systems                                      |
| [Deep Spiking Residual Shrinkage Network for Bearing Fault Diagnosis](https://ieeexplore.ieee.org/abstract/document/9994622) |                                                              | IEEE Transactions on Cybernetics                             |
| [Control and regulation of skyrmionics’ topological charge in a novel synthetic antiferromagnetic nanostructure](https://pubs.rsc.org/en/content/articlelanding/2023/nr/d2nr06498g) |                                                              | Nanoscale                                                    |
| [Accurate ECG Classification Based on Spiking Neural Network and Attentional Mechanism for Real-Time Implementation on Personal Portable Devices](https://www.mdpi.com/2079-9292/11/12/1889) |                                                              | Electronics                                                  |
| [Dynamic Threshold Integrate and Fire Neuron Model for Low Latency Spiking Neural Networks](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4179879) |                                                              |                                                              |
| [Neuromorphic-P2M: Processing-in-Pixel-in-Memory Paradigm for Neuromorphic Image Sensors](https://arxiv.org/abs/2301.09111) |                                                              |                                                              |
| [Bioinspired membrane learnable spiking neural network for autonomous vehicle sensors fault diagnosis under open environments](https://www.sciencedirect.com/science/article/pii/S0951832023000170) |                                                              | Reliability Engineering & System Safety                      |
| [Surrogate-Assisted Cooperative Co-evolutionary Reservoir Architecture Search for Liquid State Machines](https://ieeexplore.ieee.org/abstract/document/10005101) |                                                              | IEEE Transactions on Emerging Topics in Computational Intelligence |
| [Supervised Learning Algorithm Based on Spike Train Inner Product for Deep Spiking Neural Networks](https://www.mdpi.com/2076-3425/13/2/168) |                                                              | Brain Sciences                                               |
| [Mitigating Catastrophic Forgetting in Spiking Neural Networks through Threshold Modulation](https://openreview.net/forum?id=15SoThZmtU) | https://github.com/Thvnvtos/Nm-SNN                           | Transactions on Machine Learning Research                    |
| [Optical Flow estimation with Event-based Cameras and Spiking Neural Networks](https://arxiv.org/abs/2302.06492) | https://github.com/J-Cuadrado/OF_EV_SNN                      |                                                              |
| [Poster: Backdoor Attacks on Spiking NNs and Neuromorphic Datasets](https://dl.acm.org/doi/10.1145/3548606.3563532) | https://github.com/GorkaAbad/NeuromorphicBackdoors           | CCS 2022                                                     |
| [Sneaky Spikes: Uncovering Stealthy Backdoor Attacks in Spiking Neural Networks with Neuromorphic Data](https://arxiv.org/abs/2302.06279) |                                                              |                                                              |
| [SpikeGPT: Generative Pre-trained Language Model with Spiking Neural Networks](https://arxiv.org/abs/2302.13939) | https://github.com/ridgerchu/SpikeGPT                        |                                                              |
| [Trainable quantization for Speedy Spiking Neural Networks](https://www.frontiersin.org/articles/10.3389/fnins.2023.1154241/full) |                                                              | Frontiers in Neuroscience                                    |

If you use SpikingJelly in your paper, you can also add it to this table by pull request.

