scripts=(
    ## rope
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=rope_4k_s5__8402                    --ctx_len=4096   --seed=51 --runname=rope_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=rope_4k_s5__8402                    --ctx_len=4096   --seed=50 --runname=rope_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=rope_4k_s5__8402                    --ctx_len=4096   --seed=52 --runname=rope_4k_train4k_s52"

    ## sfa and p rope
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=sfa_and_p_rope_4k_s5__60fd          --ctx_len=4096   --seed=50 --runname=sfa_and_p_rope_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=sfa_and_p_rope_4k_s5__60fd          --ctx_len=4096   --seed=51 --runname=sfa_and_p_rope_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=sfa_and_p_rope_4k_s5__60fd          --ctx_len=4096   --seed=52 --runname=sfa_and_p_rope_4k_train4k_s52"

    ## p rope
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=p_rope_4k_s5__989b                 --ctx_len=4096   --seed=50 --runname=p_rope_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=p_rope_4k_s5__989b                 --ctx_len=4096   --seed=51 --runname=p_rope_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=p_rope_4k_s5__989b                 --ctx_len=4096   --seed=52 --runname=p_rope_4k_train4k_s52"

    ## nousyarn
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=nousyarn_4k_s5__2931                 --ctx_len=4096   --seed=50 --runname=nousyarn_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=nousyarn_4k_s5__2931                 --ctx_len=4096   --seed=51 --runname=nousyarn_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=nousyarn_4k_s5__2931                 --ctx_len=4096   --seed=52 --runname=nousyarn_4k_train4k_s52"

    ## ntk aware
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=ntk_aware_4k_s5__4a6e                 --ctx_len=4096   --seed=50 --runname=ntk_aware_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=ntk_aware_4k_s5__4a6e                 --ctx_len=4096   --seed=51 --runname=ntk_aware_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=ntk_aware_4k_s5__4a6e                 --ctx_len=4096   --seed=52 --runname=ntk_aware_4k_train4k_s52"

    ## logn trick learnS
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_learnS_4k_s5__a888   --ctx_len=4096   --seed=50 --runname=logn_trick_and_p_rope_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_learnS_4k_s5__a888   --ctx_len=4096   --seed=51 --runname=logn_trick_and_p_rope_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_learnS_4k_s5__a888   --ctx_len=4096   --seed=52 --runname=logn_trick_and_p_rope_4k_train4k_s52"

    ## logn trick and p rope learnS
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_and_p_rope_learnS_4k_s5__35b8   --ctx_len=4096   --seed=50 --runname=logn_trick_and_p_rope_learnS_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_and_p_rope_learnS_4k_s5__35b8   --ctx_len=4096   --seed=51 --runname=logn_trick_and_p_rope_learnS_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_and_p_rope_learnS_4k_s5__35b8   --ctx_len=4096   --seed=52 --runname=logn_trick_and_p_rope_learnS_4k_train4k_s52"

    ## logn trick and ntk aware learnS
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_and_ntk_aware_learnS_4k_s5__ded3   --ctx_len=4096   --seed=50 --runname=logn_trick_and_ntk_aware_learnS_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_and_ntk_aware_learnS_4k_s5__ded3   --ctx_len=4096   --seed=51 --runname=logn_trick_and_ntk_aware_learnS_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=logn_trick_and_ntk_aware_learnS_4k_s5__ded3   --ctx_len=4096   --seed=52 --runname=logn_trick_and_ntk_aware_learnS_4k_train4k_s52"

    ## alibi
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=alibi_4k_s5__c1f8                 --ctx_len=4096   --seed=50 --runname=alibi_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=alibi_4k_s5__c1f8                 --ctx_len=4096   --seed=51 --runname=alibi_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=alibi_4k_s5__c1f8                 --ctx_len=4096   --seed=52 --runname=alibi_4k_train4k_s52"

    ## nope
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=again_nope_4k_s5__0efb                 --ctx_len=4096   --seed=50 --runname=again_nope_4k_train4k_s50"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=again_nope_4k_s5__0efb                 --ctx_len=4096   --seed=51 --runname=again_nope_4k_train4k_s51"
    "python ./ft_nih_gpt2.py --resume_step=4578 --run_id=again_nope_4k_s5__0efb                 --ctx_len=4096   --seed=52 --runname=again_nope_4k_train4k_s52"
)

for s in "${scripts[@]}"; do
    lbatch -c 1 -g 1 -t 4 -m 64 -a cosc020762 --exclude_node="bp1-gpu031,bp1-gpu032" --gputype A100 --queue cnu --cmd "source ./slurmenv.sh && $s"
done
