#!/bin/bash

# 4k scripts
scripts_4k=(
    "python ./train_gpt2.py --runname=alibi_4k_s5         --alibi         --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=alibi_4k_s6         --alibi         --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=alibi_4k_s8         --alibi         --train_seq_length=4096 --seed=8"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_4k_s5         --sfa_and_p_rope         --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_4k_s6         --sfa_and_p_rope         --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_4k_s8         --sfa_and_p_rope         --train_seq_length=4096 --seed=8"
    "python ./train_gpt2.py --runname=sfa_and_nope_4k_s5         --sfa_and_nope         --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_nope_4k_s6         --sfa_and_nope         --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=sfa_and_nope_4k_s8         --sfa_and_nope         --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=sfa_and_rope_4k_s5         --sfa_and_rope         --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_rope_4k_s6         --sfa_and_rope         --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=sfa_and_rope_4k_s8         --sfa_and_rope         --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=p_rope_4k_s5                 --p_rope                 --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=p_rope_4k_s6                 --p_rope                 --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=p_rope_4k_s8                 --p_rope                 --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=nousyarn_4k_s5         --nousyarn         --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=nousyarn_4k_s6         --nousyarn         --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=nousyarn_4k_s8         --nousyarn         --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=rope_4k_s5                   --rope                   --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=rope_4k_s6                   --rope                   --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=rope_4k_s8                   --rope                   --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=again_nope_4k_s5                   --nope                   --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=again_nope_4k_s6                   --nope                   --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=again_nope_4k_s8                   --nope                   --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=logn_trick_learnS_4k_s5  --log_n_trick --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_learnS_4k_s6  --log_n_trick --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=logn_trick_learnS_4k_s8  --log_n_trick --train_seq_length=4096 --seed=8"
    "python ./train_gpt2.py --runname=logn_trick_and_ntk_aware_learnS_4k_s5             --log_n_trick_and_ntk_aware            --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_and_ntk_aware_learnS_4k_s6             --log_n_trick_and_ntk_aware            --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=logn_trick_and_ntk_aware_learnS_4k_s8             --log_n_trick_and_ntk_aware            --train_seq_length=4096 --seed=8"
    "python ./train_gpt2.py --runname=logn_trick_and_p_rope_learnS_4k_s5  --log_n_trick_and_p_rope --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_and_p_rope_learnS_4k_s6  --log_n_trick_and_p_rope --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=logn_trick_and_p_rope_learnS_4k_s8  --log_n_trick_and_p_rope --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=ntk_aware_4k_s5  --ntk_aware --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=ntk_aware_4k_s6  --ntk_aware --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=ntk_aware_4k_s8  --ntk_aware --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=infini_rope_4k_s5  --infini --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=infini_rope_4k_s6  --infini --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=infini_rope_4k_s8  --infini --train_seq_length=4096 --seed=8"
    "python ./train_gpt2.py --runname=infini_p_rope_4k_s5  --infini_p_rope --train_seq_length=4096 --seed=5"
    "python ./train_gpt2.py --runname=infini_p_rope_4k_s6  --infini_p_rope --train_seq_length=4096 --seed=6"
    "python ./train_gpt2.py --runname=infini_p_rope_4k_s8  --infini_p_rope --train_seq_length=4096 --seed=8"

    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_0p01_4k_s0 --tau=0.01 --sfa_and_p_rope --train_seq_length=4096 --seed=0"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_0p1_4k_s0  --tau=0.1 --sfa_and_p_rope --train_seq_length=4096 --seed=0"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_1_4k_s0    --tau=1. --sfa_and_p_rope --train_seq_length=4096 --seed=0"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_10_4k_s0   --tau=10. --sfa_and_p_rope --train_seq_length=4096 --seed=0"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_100_4k_s5  --tau=100. --sfa_and_p_rope --train_seq_length=4096 --seed=0"

    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_0p01_4k_s1 --tau=0.01 --sfa_and_p_rope --train_seq_length=4096 --seed=1"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_0p1_4k_s1  --tau=0.1 --sfa_and_p_rope --train_seq_length=4096 --seed=1"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_1_4k_s1    --tau=1. --sfa_and_p_rope --train_seq_length=4096 --seed=1"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_10_4k_s1   --tau=10. --sfa_and_p_rope --train_seq_length=4096 --seed=1"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_100_4k_s1  --tau=100. --sfa_and_p_rope --train_seq_length=4096 --seed=1"

    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_0p01_4k_s2 --tau=0.01 --sfa_and_p_rope --train_seq_length=4096 --seed=2"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_0p1_4k_s2  --tau=0.1 --sfa_and_p_rope --train_seq_length=4096 --seed=2"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_1_4k_s2    --tau=1. --sfa_and_p_rope --train_seq_length=4096 --seed=2"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_10_4k_s2   --tau=10. --sfa_and_p_rope --train_seq_length=4096 --seed=2"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_tau_100_4k_s2  --tau=100. --sfa_and_p_rope --train_seq_length=4096 --seed=2"


)

# 16k scripts
scripts_16k=(
    "python ./train_gpt2.py --runname=sfa_and_nope_16k_s5        --sfa_and_nope                            --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_16k_s5      --sfa_and_p_rope                          --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_rope_16k_s5        --sfa_and_rope                            --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=rope_16k_s5                --rope                                    --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=again_nope_16k_s5          --nope                                    --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=alibi_16k_s5               --alibi                                   --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_learnS_16k_s5                --log_n_trick                --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_and_p_rope_learnS_16k_s5     --log_n_trick_and_p_rope     --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=ntk_aware_16k_s5                        --ntk_aware                  --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_and_ntk_aware_learnS_16k_s5  --log_n_trick_and_ntk_aware  --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=nousyarn_16k_s5                         --nousyarn                   --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=infini_rope_16k_s5                      --infini_rope                --train_seq_length=16384 --seed=5"
    "python ./train_gpt2.py --runname=infini_p_rope_16k_s5                    --infini_p_rope              --train_seq_length=16384 --seed=5"
)

# 64k scripts
scripts_64k=(
    "python ./train_gpt2.py --runname=sfa_and_nope_64k_s5                     --sfa_and_nope              --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_p_rope_64k_s5                   --sfa_and_p_rope            --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=sfa_and_rope_64k_s5                     --sfa_and_rope              --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=rope_64k_s5                             --rope                      --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=again_nope_64k_s5                       --nope                      --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=alibi_64k_s5                            --alibi                     --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_learnS_64k_s5                --log_n_trick               --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_and_p_rope_learnS_64k_s5     --log_n_trick_and_p_rope    --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=logn_trick_and_ntk_aware_learnS_64k_s5  --log_n_trick_and_ntk_aware --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=ntk_aware_64k_s5                        --ntk_aware                 --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=nousyarn_64k_s5                         --nousyarn                  --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=infini_rope_64k_s5                      --infini_rope               --train_seq_length=65536 --seed=5"
    "python ./train_gpt2.py --runname=infini_p_rope_64k_s5                    --infini_p_rope             --train_seq_length=65536 --seed=5"
)

# Submit 4k jobs
for s in "${scripts_4k[@]}"; do
    lbatch -c 1 -g 1 -t 18 -m 64 -a cosc020762 --exclude_node="bp1-gpu031,bp1-gpu032" --gputype A100 --queue cnu --cmd "source ./slurmenv.sh && $s"
done

# Submit 16k jobs
for s in "${scripts_16k[@]}"; do
    lbatch -c 1 -g 1 -t 48 -m 64 -a cosc020762 --exclude_node="bp1-gpu031,bp1-gpu032" --gputype A100 --queue cnu --cmd "source ./slurmenv.sh && $s"
done

# Submit 64k jobs
for s in "${scripts_64k[@]}"; do
    lbatch -c 1 -g 1 -t 72 -m 64 -a cosc020762 --exclude_node="bp1-gpu031,bp1-gpu032" --gputype A100 --queue cnu --cmd "source ./slurmenv.sh && $s"
done