# LU-500: A Logo Unlearning Benchmark

## Installation

### Step 1: Create the Environment

Use the following command to create the environment:

```bash
conda env create -f environment.yml
```

### Step 2: Set Up Diffusers

Navigate to the `diffusers` directory:

```bash
cd diffusers
```

Install the `diffusers` environment:

```bash
pip install -e .
```

**Note:** We have re-implemented the Safe Latent Diffusion and SEGA methods in `diffusers/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py`.

## Usage

### Generate Original Text-to-Image Prompts

Run the following scripts to obtain the original text-to-image prompts:

```bash
python generate_logo_prompt_explicit.py
python generate_logo_prompt_implicit.py
```

**Note:** Make sure to set your OpenAI API key before running these scripts.

### Generate Prompts Using ProLU Method

Use the following command to obtain prompts using the ProLU method:

```bash
python generate_logo_prompt_ours.py
```

### Generate Images

Run the baseline and generate images:

```bash
python run_baseline.py
```

This script will generate the original images and the images processed by the unlearn baseline.

### Logo Detection

Detect logos in the generated images by running:

```bash
python detect_logo_concept.py
```

### Metrics Calculation

Calculate five different metrics on the generated images using:

```bash
python calculate.py
```

## License
