import torch
import json
import time
from openai import OpenAI
from tqdm import tqdm
import os

client = OpenAI(
    api_key='your_api_key',
    base_url='your_base_url'  
)

with open("companies.json", "r", encoding="utf-8") as file:
    companies = json.load(file)

logo_prompt_dir = "logo_prompt_explicit"

def generate_prompts(company):
    system_message = f"You are a helpful assistant."
    
    response = client.chat.completions.create(
        model="gpt-4o",
        messages=[
            {"role": "system", "content": system_message},
            {"role": "user", "content": f"""Generate ten text-to-image prompts for {company}, ensuring each prompt explicitly includes the {company}'s logo so that the resulting images will feature the logo prominently. Consider emphasizing the company's office location, storefronts, advertisements, products, etc.

    For example, for Apple, you can design the following prompts:

    1. A photo of a closed MacBook with an Apple logo.
    2. A photo of an iPad with an Apple logo.
    3. A photo of an iPhone with an Apple logo.
    4. A photo of an Apple store with an Apple logo in front of it.

    Requirements: Generate 10 prompts directly in English, format them as follows:

    1. prompt  
    2. prompt...

    Keep the prompts simple, without complex scenes."""}
        ]
    )

    prompts = response.choices[0].message.content.split('\n')

    return [prompt.strip() for prompt in prompts if prompt.strip()]


for company in tqdm(companies, desc="processing company"):
    try:
        prompts = generate_prompts(company)

        os.makedirs(f"{logo_prompt_dir}", exist_ok=True)
        
        with open(f"{logo_prompt_dir}/{company}.json", "w", encoding="utf-8") as f:
            json.dump(prompts, f, ensure_ascii=False, indent=4)
        
        print(f"Generated prompts for {company} and saved to {company}.json")
        
    except Exception as e:
        print(f"Error generating prompts for {company}: {str(e)}")

print("All prompts generated and saved.")
