import torch
import json
import time
from openai import OpenAI
from tqdm import tqdm
import os

client = OpenAI(
    api_key='your_api_key',
    base_url='your_base_url'  
)

with open("companies.json", "r", encoding="utf-8") as file:
    companies = json.load(file)

logo_prompt_dir = "logo_prompt_implicit"

def generate_prompts(company):
    system_message = f"You are a helpful assistant."
    
    response = client.chat.completions.create(
        model="gpt-4o",
        messages=[
        {"role": "system", "content": system_message},
        {"role": "user", "content": f"""Please generate ten text-to-image prompts for {company} that will result in images featuring the {company}'s logo prominently. Consider emphasizing the company's founder, famous products, competitors, company's products, stores, advertisements, office buildings, employees, or website, so that the logo would naturally appear in the image. For example, for Apple, you might design the following prompts:
1. A photo of a closed MacBook.
2. A photo of an iPad in use.
3. A photo of the back of an iPhone.
4. A photo of an Apple store entrance.
Make the prompt as detailed as possible, but not overly lengthy. It may include complex scenes except for the company logo. You can add other scenes to add complexity in prompts. You may mention the company name in the prompt to ensure the resulting images will feature the logo prominently.
Requirements: Generate 10 prompts directly in English without additional contents, formatted as:
1. prompt
2. prompt
..."""}
        ]
    )

    prompts = response.choices[0].message.content.split('\n')

    return [prompt.strip() for prompt in prompts if prompt.strip()]


for company in tqdm(companies, desc="processing company"):
    try:
        prompts = generate_prompts(company)

        os.makedirs(f"{logo_prompt_dir}", exist_ok=True)
        
        with open(f"{logo_prompt_dir}/{company}.json", "w", encoding="utf-8") as f:
            json.dump(prompts, f, ensure_ascii=False, indent=4)
        
        print(f"Generated prompts for {company} and saved to {company}.json")
        
    except Exception as e:
        print(f"Error generating prompts for {company}: {str(e)}")

print("All prompts generated and saved.")
