import torch
from diffusers import FluxPipeline, DiffusionPipeline, SemanticStableDiffusionPipeline
from diffusers import StableDiffusion3Pipeline
from diffusers.pipelines.stable_diffusion_3.pipeline_stable_diffusion_3 import SafeStableDiffusion3Pipeline, SemanticStableDiffusion3Pipeline
import pdb
from tqdm import tqdm
import json
import os
import gc
from tqdm import tqdm
from openai import OpenAI
import torch
from diffusers import FluxPipeline
import pdb
import os

client = OpenAI(
    api_key='your_api_key',
    base_url='your_base_url'  
)

def subsitude_prompt(prompt, concept):
    conversation_history = [
        {"role": "system", "content": "You are a helpful assistant."},
        {"role": "user", "content": f"I will provide you with two pieces of text: a prompt and a concept. The prompt contains a descriptive text, and the concept represents an idea. I am working on a task to generate an image from text, where the text is the prompt, and the prompt contains the concept. However, I don't want the generated image to include the concept. Please help me modify the prompt so that the concept is either removed or replaced while making the least possible change to the meaning of the prompt. The original prompt is: {prompt}, and the concept is: {concept}. Note: you must directly output the optimized prompt without any other text."}
    ]

    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=conversation_history
    )

    prompt_1 = completion.choices[0].message.content

    conversation_history.append({"role": "assistant", "content": prompt_1})

    conversation_history.append({
        "role": "user", 
        "content": f"The modified prompt is: '{prompt_1}'. The concept to remove is: '{concept}'. Does the modified prompt still contain the concept? If it does, please adjust the prompt to ensure the concept is either removed or replaced while keeping the original meaning intact. If it does not, do not modify the prompt. Note: you must directly output the optimized prompt without any other text."
    })

    reflection = client.chat.completions.create(
        model="gpt-4o",
        messages=conversation_history
    )

    prompt_2 = reflection.choices[0].message.content

    conversation_history.append({"role": "assistant", "content": prompt_2})

    if concept.lower() in prompt_2.lower():
        conversation_history.append({
            "role": "user", 
            "content": f"The concept '{concept}' still exists in the modified prompt. You must adjust the prompt to ensure the concept is either removed or replaced while keeping the original meaning intact. Note: you must directly output the optimized prompt without any other text."
        })

        final_modification = client.chat.completions.create(
            model="gpt-4o",
            messages=conversation_history
        )

        prompt_3 = final_modification.choices[0].message.content

        conversation_history.append({"role": "assistant", "content": prompt_3})

        return prompt_3, prompt_2, prompt_1
    
    else:
        prompt_3 = prompt_2
        return prompt_3, prompt_2, prompt_1



SEED = 42
num_prompts_per_company = 10

with open("companies.json", "r", encoding="utf-8") as file:
    companies = json.load(file)


baseline_images_dir = "logo_prompt_ours_explicit"
logo_prompt_dir = "logo_prompt_explicit"
# baseline_images_dir = "logo_prompt_ours_implicit"
# logo_prompt_dir = "logo_prompt_implicit"


for company in tqdm(companies):
    json_path = f"{logo_prompt_dir}/{company}.json"
    if not os.path.exists(json_path):
        print(f"can't find {company} json file, skip")
        continue

    with open(json_path, 'r', encoding='utf-8') as f:
        prompts = json.load(f)

    for i, prompt_item in enumerate(prompts[:num_prompts_per_company], 1):
        actual_prompt = prompt_item.split('. ', 1)[1] if '. ' in prompt_item else prompt_item
        print(f"processing {company} {i}th prompt: {actual_prompt}")
        concept = f"{company} logo"
        prompt_3, prompt_2, prompt_1 = subsitude_prompt(actual_prompt, concept)

        os.makedirs(os.path.dirname(f"{baseline_images_dir}/{company}/{i}.json"), exist_ok=True)
        with open(f"{baseline_images_dir}/{company}/{i}.json", 'w', encoding='utf-8') as f:
            json.dump({
                "actual_prompt": actual_prompt,
                "prompt_1": prompt_1,
                "prompt_2": prompt_2,
                "prompt_3": prompt_3
            }, f, ensure_ascii=False, indent=4)
    











