# llms-for-planning

## Setup

1. Create and activate your virtual environment. We recommend using [pyenv](https://github.com/pyenv/pyenv) and [pyenv-virtualenv](https://github.com/pyenv/pyenv-virtualenv). 
   ```sh
   pyenv virtualenv 3.9.13 llms-for-planning
   pyenv activate llms-for-planning
   ```
2. Update the submodules
   ```sh
   git submodule update --init --recursive
   ```
3. Install [pygraphviz](https://pygraphviz.github.io/documentation/stable/install.html) and pip install it
    ```sh
    # Assuming you brew installed graphviz
    export GRAPHVIZ_DIR="$(brew --prefix graphviz)"
    pip install pygraphviz \
        --global-option=build_ext \
        --global-option="-I$GRAPHVIZ_DIR/include" \
        --global-option="-L$GRAPHVIZ_DIR/lib"
    ```
4. Install the requirements
   ```sh
   pip install -r requirements.txt
   ```
5. Copy the `.envrctemplate` and fill in the necessary environment variables. Consider using [direnv](https://direnv.net/docs/hook.html).
   ```sh
   cp .envrctemplate .envrc
   # Fill in variables and save file
   direnv allow .
   ```

6. `cd LLMs-Planning` and clone and install Fast Downward

7. Export API keys
   `export OPENAI_API_KEY=`

## Other libraries used
   Lifted PDDL, Fast Downward, PlanBench

## Running I/O methods on Blocksworld
1. `cd LLMs-Planning`
2. `python run_blocksworld.py --config blocksworld.json`

## Running interactive methods on Blocksworld, Grippers and Logistics
`python main_script.py --multirun ++domain=logistics +experiments=ReAct_planner_logistics +planner.domain_file=data/logistics.pddl +planner.instance_dir=data/logistics ++planner.samples=1`

## Corresponding Hydra experiments for methods
1. ReAct: `ReAct_planner` (different suffix for grippers and logistics see `conf/experiment`)
2. ReAct-Select: `backtrack_planner`
3. Fast Downward: `fd_planner`
4. ToI-BFS: `tot_bfs_planner`
5. ToI-DFS: `tot_dfs_planner`
6. Boomerang: `lazy_planner`

