import os
from easydict import EasyDict


class Property(EasyDict):
    def __init__(self,
                 num_class: int,
                 num_example: int,
                 prefix: str,
                 name: str,
                 ):
        super(Property, self).__init__()
        self.num_class = num_class
        self.num_example = num_example
        self.prefix = prefix
        self.name = name

    def __repr__(self) -> str:
        msg = "\n"
        for k, v in self.items():
            k = f"{k}:"
            k = format(k, "<30")
            msg += f"{k} {v}\n"
        return msg

rank = int(os.getenv("RANK", "0"))
world_size = int(os.getenv("WORLD_SIZE", "1"))

LAION400M = Property(
    num_class=None, num_example=389737314, name="LAION",
    prefix=[f"/mnt/LAION400M/train_{i :04d}" for i in range(64)])
