import argparse
import numpy as np
from causally.start.quick_start import run_casual
from causally.start.quick_start_for_pretrain import run_pretrain
from causally.config.configurator import Config
from logging import getLogger
from causally.utils.output import save_result, save_result_exp1_hidden
import warnings 
warnings.filterwarnings("ignore") 

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--exp_info', type=str, default='default', help='optimizer') 
    parser.add_argument('--dataset', type=str, default='ACIC-StandardScalerX', help='The dataset.')
    parser.add_argument('--model', type=str,default='CFR_WASS', help='The model for estimating casual effect') 
    parser.add_argument('--trainer', type=str, default='auto_diff_XXX', help='training method.') 
    args, _ = parser.parse_known_args()
    config = Config(args = args)
    run_pretrain(config=config)


