"""
Output format error for agent responses.

This module provides a simple exception class used by all agents to handle
parsing errors in LLM responses. It's kept minimal since each agent now
has its own specific parsing logic.
"""


class OutputFormatError(Exception):
    """
    Custom exception raised when LLM output format is invalid or cannot be parsed.
    
    This exception is used across all agents (LinkerGenerator, ShapeGenerator, 
    ArticulationGenerator) when they encounter malformed responses that don't
    match their expected output formats.
    
    Examples:
        - Missing JSON array in linker response
        - Missing code blocks in shape response  
        - Invalid JSON structure in articulation response
    """
    pass