"""
Simple color utility for logging - minimal approach
"""

class Colors:
    GREEN = '\033[92m'  # Success
    BLUE = '\033[94m'   # Progress  
    RED = '\033[91m'    # Error
    YELLOW = '\033[93m' # Warning
    CYAN = '\033[96m'   # Statistics
    RESET = '\033[0m'   # Reset color

def success(msg):
    """Green for success messages"""
    return f"{Colors.GREEN}{msg}{Colors.RESET}"

def progress(msg):
    """Blue for progress messages"""
    return f"{Colors.BLUE}{msg}{Colors.RESET}"

def error(msg):
    """Red for error messages"""
    return f"{Colors.RED}{msg}{Colors.RESET}"

def warning(msg):
    """Yellow for warning messages"""  
    return f"{Colors.YELLOW}{msg}{Colors.RESET}"

def stats(msg):
    """Cyan for statistics"""
    return f"{Colors.CYAN}{msg}{Colors.RESET}"